% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animLineChart.R
\name{animLineChart}
\alias{animLineChart}
\title{Create an animated line chart}
\usage{
animLineChart(
  data,
  x,
  y,
  curve = "curveLinear",
  duration = 5000,
  stroke = "crimson",
  strokeWidth = 1.5,
  xticks = NULL,
  yticks = NULL,
  xtitle = NULL,
  xtitleFontSize = 16,
  ytitle = NULL,
  ytitleFontSize = 16,
  title = NULL,
  titleFontSize = 22,
  font = "Verdana, Geneva, Tahoma, sans-serif",
  bgcol = "#CAD0D3",
  opacity = 1,
  axisCol = "black",
  width = NULL,
  height = NULL
)
}
\arguments{
\item{data}{The data frame containing the variables to consider.}

\item{x}{The x-variable to consider. Must be a date variable in 'yyyy-mm-dd' format.}

\item{y}{The y-variable to consider.}

\item{curve}{Optional. The line's curve type to render.
A complete list can be found here <https://github.com/d3/d3-shape#curves>.
Defaults to 'curveLinear'.}

\item{duration}{The duration in Milliseconds of the animation. Defaults to 5000.}

\item{stroke}{The color of the line. Defaults to 'crimson'.}

\item{strokeWidth}{The width of the line. Defaults to 1.5.}

\item{xticks}{Optional. the number of x-axis ticks to consider.}

\item{yticks}{Optional. The number of y-axis ticks to consider.}

\item{xtitle}{Optional. The title of the x-axis.}

\item{xtitleFontSize}{The font size of the x-axis title. Defaults to 16.}

\item{ytitle}{Optional. The title of the y-axis.}

\item{ytitleFontSize}{The font size of the y-axis title. Defaults to 16.}

\item{title}{Optional. The title of the plot.}

\item{titleFontSize}{The font size of the plot title. Defaults to 22.}

\item{font}{The font family to consider for the titles. Defaults to
"Verdana, Geneva, Tahoma, sans-serif".}

\item{bgcol}{The background color of the SVG. Defaults to "#CAD0D3" HEX color.}

\item{opacity}{The color opacity of the bars (from 0 to 1). Defaults to 1.}

\item{axisCol}{the color of the x and y axis. It includes the ticks, the labels and titles.
Defaults to 'black'.}

\item{width}{Optional. The width of the SVG output.}

\item{height}{Optional. The height of the SVG output.}
}
\value{
An animated SVG line chart.
}
\description{
Create an animated line chart
}
\examples{
airpassengers <- data.frame(
 passengers = as.matrix(AirPassengers),
 date= zoo::as.Date(time(AirPassengers))
)
animLineChart(
 data = airpassengers,
 x = "date",
 y = "passengers",
 duration = 10000 # in milliseconds (10 seconds)
)
}
