% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supported_glossary_language_pairs2.R
\name{supported_glossary_language_pairs2}
\alias{supported_glossary_language_pairs2}
\title{List Supported Glossary Language Pairs with the DeepL API Free}
\usage{
supported_glossary_language_pairs2(auth_key)
}
\arguments{
\item{auth_key}{A string representing the authentication key for the DeepL API Free. 
If not provided, the function will attempt to retrieve the key from the environment 
variable \code{DEEPL_API_KEY}. You can set this variable using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} 
file for persistent use.}
}
\description{
\code{supported_glossary_language_pairs2} lists all language pairs supported for glossary creation 
    in the DeepL API Free.
}
\details{
To use this function, you must obtain an authentication key by registering for a DeepL API Free account at 
    \href{https://www.deepl.com/pro#developer}{DeepL API Free}.
}
\examples{
\dontrun{
supported_glossary_language_pairs2()
}

}
\references{
\href{https://developers.deepl.com/docs/api-reference/glossaries#list-supported-glossary-language-pairs}{DeepL API Documentation — Supported Glossary Language Pairs}
}
