% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{w.ggbarstats}
\alias{w.ggbarstats}
\title{Wrapper for ggstatsplot::ggbarstats with optional p-value annotation}
\usage{
w.ggbarstats(
  data,
  parameter,
  groupby = NULL,
  pval.display = FALSE,
  ldat,
  tip_length = 4e-04,
  pval_y_position = 1.05,
  ...
)
}
\arguments{
\item{data}{A data frame with the data to be plotted.}

\item{parameter}{Character. Name of the column in \code{data} to the values to be plotted.}

\item{groupby}{Character (default: NULL). Name of the grouping (categorical) variable in \code{data}.}

\item{pval.display}{Logical. If \code{TRUE} and there are exactly two groups in \code{x}, a p-value annotation is added.}

\item{ldat}{A data frame containing the p-value(s) to annotate on the plot. Expected columns: `"p value"` and/or `"adjusted p value"`.}

\item{tip_length}{Numeric. Length of the annotation tips for \code{geom_signif} (default: 0.0004).}

\item{pval_y_position}{Numeric. Vertical position for the p-value annotation (default: 1.05).}

\item{...}{Additional arguments passed to \code{\link[ggstatsplot]{ggbarstats}}.}
}
\value{
A \code{ggplot} object.
}
\description{
This function creates a `ggbarstats` plot from `ggstatsplot`, and optionally adds a p-value annotation using `geom_signif` for two-group comparisons based on values in `ldat`.
}
\details{
If \code{groupby} is not \code{NULL} and there are exactly two levels in the grouping variable, and \code{pval.display = TRUE}, a p-value from \code{ldat} is added between the two groups using \code{geom_signif}. If \code{"adjusted p value"} is present in \code{ldat}, it is used; otherwise, \code{"p value"} is used.
}
\examples{
## ungrouped plot
p <- w.ggbarstats(mtcars, "gear",
                  bf.message = FALSE,
                  proportion.test = FALSE)
if (FALSE) print(p)

## grouped plot
p <- w.ggbarstats(mtcars, "gear", groupby = "cyl",
                  bf.message = FALSE,
                  proportion.test = FALSE)
if (FALSE) print(p)

## grouped plot with p value annotation for >2 groups
pval <- fisher.test(mtcars$gear, mtcars$cyl)$p.value
pval <- descutils::prettyPvalues(pval, digits = 3, orgbold = FALSE, lhs = "p")
ldat <- data.frame(`p value` = pval, check.names = FALSE)
p <- w.ggbarstats(mtcars, "gear", groupby = "cyl", pval.display = TRUE, ldat = ldat,
                  bf.message = FALSE,
                  proportion.test = FALSE)
if (FALSE) print(p)

## grouped plot with p value annotation for two groups
pval <- fisher.test(mtcars$gear, mtcars$vs)$p.value
pval <- descutils::prettyPvalues(pval, digits = 3, orgbold = FALSE, lhs = "p")
ldat <- data.frame(`p value` = pval, check.names = FALSE)
p <- w.ggbarstats(mtcars, "gear", groupby = "vs", pval.display = TRUE, ldat = ldat,
                  bf.message = FALSE,
                  proportion.test = FALSE)
if (FALSE) print(p)
}
\author{
Fabian Kück
}
