% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_measures.R
\name{measures}
\alias{measures}
\title{Forecasting Accuracy Measure Calculation}
\usage{
measures(preds, obs)
}
\arguments{
\item{preds}{the point predictions for the test data period.}

\item{obs}{the observation series (training data and test data)}
}
\value{
A named vector with the obtained criteria values is returned.
}
\description{
Given point forecasts and observations, calculate various forecasting 
accuracy measures.
}
\details{
Given one-step-ahead rolling forecasts as well as the whole series of given 
observations (training together with test data), different forecasting 
accuracy measures (MAE, RMSE, Pearson's correlation, MASE, RMSSE) are being 
calculated.
}
\examples{
\donttest{
xt <- EXPENDITURES
xt_in <- window(xt, end = c(2017, 4))
yt <- log(xt_in)
est <- s_semiarma(yt, set_options(order_poly = 3), inflation_rate = "optimal")
fc_results <- predict(est, n.ahead = 8, expo = TRUE)
point_fc <- fc_results@pred
measures(point_fc, xt)
}

}
