% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_funs.R
\name{CSPA}
\alias{CSPA}
\title{Cluster-based Similarity Partitioning Algorithm (CSPA)}
\usage{
CSPA(E, k)
}
\arguments{
\item{E}{is an array of clustering results.}

\item{k}{number of clusters}
}
\value{
cluster assignments for the consensus class
}
\description{
Performs hierarchical clustering on a stack of consensus matrices to obtain
consensus class labels.
}
\examples{
data(hgsc)
dat <- hgsc[1:100, 1:50]
x <- consensus_cluster(dat, nk = 4, reps = 4, algorithms = c("hc", "diana"),
progress = FALSE)
CSPA(x, k = 4)
}
\references{
Strehl, A., & Ghosh, J. (2002). Cluster ensembles---a knowledge
reuse framework for combining multiple partitions. Journal of machine
learning research, 3(Dec), 583-617.
}
\seealso{
Other consensus functions: 
\code{\link{LCA}()},
\code{\link{LCE}()},
\code{\link{k_modes}()},
\code{\link{majority_voting}()}
}
\author{
Derek Chiu
}
\concept{consensus functions}
