% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{miller_2007}
\alias{miller_2007}
\title{Miller et al. (2007) data}
\format{
A tibble with 296 rows and 4 variables.
}
\source{
\href{https://www.discovr.rocks/csv/miller_2007.csv}{www.discovr.rocks/csv/miller_2007.csv}
}
\usage{
miller_2007
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Miller and colleagues (2007) tested the \emph{hidden-estrus} theory, which suggests that unlike other female mammals,
humans do not experience an \emph{estrus} phase during which they are more sexually receptive, proceptive, selective and attractive.
If this theory is wrong then human men should find women most attractive during the fertile phase of their menstrual cycle compared
to the pre-fertile (menstrual) and post-fertile (luteal) phase. Miller used the tips obtained by dancers at a lap dancing club as a proxy
for their sexual attractiveness and also recorded the phase of the dancer's menstrual cycle during a given shift, and whether they were using hormonal contraceptives.
Dancers provided data from between 9 to 29 of their shifts.
\itemize{
\item \strong{id}: Dancer's ID.
\item \strong{contraceptive}: whether the dancer was currently using oral hormonal contraceptives.
\item \strong{cyclephase}: the phase of the dancer's menstrual cycle at the time of a particular shift.
\item \strong{tips}: The tips (in US dollars) received during a particular shift
}
}
\references{
\itemize{
\item Miller, G., Tybur, J. M., & Jordan, B. D. (2007). Ovulatory cycle effects on tip earnings by lap dancers: Economic evidence for human estrus? \emph{Evolution and Human Behavior}, 28, 375–381. \doi{10.1016/j.evolhumbehav.2007.06.002}
}
}
\keyword{datasets}
