distfreereg.lmerMod <-
  function(test_mean,
           ordering = "simplex",
           group = TRUE,
           stat = c("KS", "CvM"),
           B = 1e4,
           control = NULL,
           override = NULL,
           verbose = TRUE,
           ...){
    stopifnot(is(test_mean, "lmerMod"))
    
    parent_envir <- parent.frame()

    cl <- match.call()
    
    extra_arg_list <- list(...)
    
    validate_args_distfreereg_lmerMod(test_mean = test_mean,
                                  extra_arg_list = extra_arg_list)
    
    m <- test_mean
    X <- getME(m, "X"); Y <- getME(m, "y")
    n <- length(Y)
    
    # Get the covariance.
    covariance <- get_cov(m = m, verbose = verbose)

    # Get the estimated Jacobian and the fitted values.
    if(is.null(override[["J"]])){
      if(isTRUE(verbose)) message("Calculating Jacobian from 'lmerMod' object...")
      J <- get_jacobian(m, verbose = verbose)
    } else {
      if(isTRUE(verbose)) message("Using supplied Jacobian...")
      J <- override[["J"]]
      override[["J"]] <- NULL
    }
    
    if(is.null(override[["fitted_values"]])){
      if(isTRUE(verbose)) message("Retrieving fitted values from 'lmerMod' object...")
      fitted_values <- predict(m, re.form = NA)
    } else {
      if(isTRUE(verbose)) message("Using supplied fitted values...")
      fitted_values <- override[["fitted_values"]]
      override[["fitted_values"]] <- NULL
    }
    
    data <- get_data(m, envir = parent_envir)
        
    control <- define_data_for_res_order(test_mean = test_mean, data = data,
                                         ordering = ordering,
                                         override = override, control = control)
    
    dfr_default_output <-
      distfreereg.default(Y = Y, X = X, covariance = covariance, ordering = ordering,
                          group = group, J = J, fitted_values = fitted_values,
                          stat = stat, B = B, control = control, override = override,
                          verbose = verbose)
    
    output <- list(
      call = cl,
      data = list(data = m@frame, Y = Y, X = X),
      test_mean = m,# makes sure that output includes x and y in lm object
      covariance = dfr_default_output[["covariance"]],
      theta_hat = fixef(m),
      optimization_output = NULL
    )
    
    output <- combine_lists(output, dfr_default_output)
    
    if(is(dfr_default_output[[length(dfr_default_output)]], "error")){
      class(output) <- "distfreereg-error"
    } else {
      class(output) <- "distfreereg"
    }
    
    return(output)
  }
