distfreereg.nls <-
  function(test_mean,
           ordering = "simplex",
           group = TRUE,
           stat = c("KS", "CvM"),
           B = 1e4,
           control = NULL,
           override = NULL,
           verbose = TRUE,
           ...){
    stopifnot(is(test_mean, "nls"))
    
    cl <- match.call()
    
    extra_arg_list <- list(...)
    
    m <- test_mean
    n <- length(fitted(m))
    
    control <- validate_args_distfreereg_nls(test_mean = m, n = n,
                                             control = control,
                                             extra_arg_list = extra_arg_list,
                                             verbose = verbose)
    
    # Get the covariance.
    covariance <- get_cov(m, verbose = verbose)
    
    # Get the estimated Jacobian and the fitted values.
    if(is.null(override[["J"]])){
      if(isTRUE(verbose)) message("Calculating Jacobian from 'nls' object...")
      J <- get_jacobian(m = m, verbose = verbose)
      # The returned value is the normalized gradient; that is, the gradient of
      # the original function left multiplied by the inverse square root of the
      # covariance. For consistency with what comes later, this multiplication
      # must be undone.
      covariance <- fill_covariance_list(need = "SqrtSigma",
                                         covariance_list = covariance,
                                         matsqrt_tol = control[["matsqrt_tol"]],
                                         solve_tol = control[["solve_tol"]])
      J <- covprod(covariance[["SqrtSigma"]], J)
    } else {
      if(isTRUE(verbose)) message("Using supplied Jacobian...")
      J <- override[["J"]]
      override[["J"]] <- NULL
    }
    
    if(is.null(override[["fitted_values"]])){
      if(isTRUE(verbose)) message("Retrieving fitted values from 'nls' object...")
      fitted_values <- as.vector(fitted(m))
    } else {
      if(isTRUE(verbose)) message("Using supplied fitted values...")
      fitted_values <- override[["fitted_values"]]
      override[["fitted_values"]] <- NULL
    }
    
    data <- get_data(m)
    X <- data
    X[[get_response(formula(m))]] <- NULL
    X <- as.matrix(X)
    Y <- m[["m"]][["lhs"]]()
    
    control <- define_data_for_res_order(test_mean = m, data = data,
                                         ordering = ordering,
                                         override = override, control = control)
    
    dfr_default_output <-
      distfreereg.default(Y = Y, X = X, covariance = covariance, ordering = ordering,
                          group = group, J = J, fitted_values = fitted_values,
                          stat = stat, B = B, control = control, override = override,
                          verbose = verbose)
    
    output <- list(
      call = cl,
      data = list(data = get_data(m), Y = Y, X = X),
      test_mean = m,
      covariance = dfr_default_output[["covariance"]],
      theta_hat = m[["m"]][["getPars"]](),
      optimization_output = m
    )
    
    output <- combine_lists(output, dfr_default_output)
    
    if(is(dfr_default_output[[length(dfr_default_output)]], "error")){
      class(output) <- "distfreereg-error"
    } else {
      class(output) <- "distfreereg"
    }
    
    return(output)
  }
