% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render_pdf}
\alias{render_pdf}
\title{Render to pdf}
\usage{
render_pdf(
  x,
  display_loc = NULL,
  transform = NULL,
  header_latex = NULL,
  keep_tex = FALSE,
  escape_latex = TRUE,
  quarto = FALSE
)
}
\arguments{
\item{x}{\code{docorator} object}

\item{display_loc}{optional path to save the output pdf to}

\item{transform}{optional latex transformation function to apply to a gt latex string}

\item{header_latex}{optional .tex file of header latex}

\item{keep_tex}{Boolean indicating if to keep resulting .tex file from latex conversion. Defaults to FALSE.}

\item{escape_latex}{Boolean indicating if headers and footers of a gt table should be escaped with gt::escape_latex}

\item{quarto}{Boolean indicating whether to use Quarto as the rendering
engine. Defaults to \code{FALSE}, which uses Rmarkdown to render. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}
}
\value{
This function saves a pdf to a specified location
}
\description{
Render to pdf
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt::gtcars |>
  dplyr::slice_head(n = 10) |>
  dplyr::select(mfr, model, year, msrp) |>
  gt::gt(groupname_col = "mfr",
         row_group_as_column = TRUE) |>
  as_docorator(
   header = fancyhead(fancyrow("Header 1"), fancyrow("Header 2")),
   display_name = "mytbl") |>
 render_pdf()
}\if{html}{\out{</div>}}
}

