% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_tree.R
\name{train_tree}
\alias{train_tree}
\title{Fit a Decision Tree Model}
\usage{
train_tree(
  data_train = NULL,
  data = NULL,
  target_lab = NULL,
  model = c("rpart", "party", "C50", "caret"),
  task = c("classification", "regression"),
  control = NULL
)
}
\arguments{
\item{data_train}{Data frame. Explicit training set. If NULL, will be subset from \code{data} by \code{data_type == 'train'}.}

\item{data}{Data frame. Combined dataset with a \code{data_type} column when \code{data_train} is NULL.}

\item{target_lab}{Character. Name of the target column to predict.}

\item{model}{Character. Which implementation to use: one of "rpart", "party", "C50", or "caret".}

\item{task}{Character. Type of task: "classification" or "regression".}

\item{control}{List or control object. Optional control parameters passed to the chosen tree function.}
}
\value{
A list with elements:
\item{fit}{A party object representing the fitted tree.}
\item{var_imp}{A named numeric vector of relative variable importance (scaled to sum to 1 and rounded to two decimals).}
}
\description{
Fits a decision tree to training data using one of several supported tree implementations
(rpart, party, C50, or via caret) and returns a standardized party object along with
variable importance scores.
}
\examples{

library(partykit)
library(C50)
library(caret)

data(train_covid)
train_tree(data_train = train_covid, target_lab = "Outcome", model = "rpart")
train_tree(data_train = train_covid, target_lab = "Outcome", model = "C50")
train_tree(data_train = train_covid, target_lab = "Outcome", model = "caret")

data(Psychosis_Disorder)
data <- add_data_type(data_all = Psychosis_Disorder)
data <- prepare_features(data, target_lab = "UNIQID", task = "classification")
train_tree(
  data = data, target_lab = "UNIQID", model = "party",
  control = ctree_control(minbucket = 15)
)
}
