% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fasta.R
\name{fasta_writer}
\alias{fasta_writer}
\alias{fastq_writer}
\title{Read FASTA or FASTQ files into a tibble}
\usage{
fasta_writer(df, sequence, header, file.out)

fastq_writer(df, sequence, header, Qscores, file.out)
}
\arguments{
\item{df}{A dataframe where the sequence information is stored, one sequence per row}

\item{sequence}{The name (unquoted) of the column where the sequence information (as characters) is stored}

\item{header}{The name (unquoted) of the column where the header information is stored}

\item{file.out}{Character. Path to the location where to write the file.}

\item{Qscores}{The name (unquoted) of the column where the Quality information (encoded as characters) is stored}
}
\value{
- `fasta_reader()`: A tibble with columns:
  - `header`: sequence identifiers (without the `>`).
  - `seq`: nucleotide sequences.

- `fastq_reader()`: A tibble with columns:
  - `header`: sequence identifiers (without the `@`).
  - `seq`: nucleotide sequences.
  - `Qscores` (optional): quality scores, if `keepQ = TRUE`.
}
\description{
Functions to read sequence files into a tidy data frame with one row per sequence.
}
\examples{
fasta_file <- tempfile(fileext = ".fasta")

fasta_df <- fasta_reader(system.file("extdata", "test.fasta", package="eDNAfuns"))

fasta_writer(fasta_df, sequence=seq,
              header = header,
              file.out = fasta_file)
 
fastq_file <- tempfile(fileext = ".fastq")  
           
fastq_df <- fastq_reader(system.file("extdata", "test.fastq", package="eDNAfuns"), keepQ = TRUE)

fastq_writer(fastq_df, sequence=seq,
              header = header,Qscores= Qscores,
              file.out = fastq_file)

}
