% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_reference_parse}
\alias{EPM_reference_parse}
\title{Parse and Format References.}
\usage{
EPM_reference_parse(x, max_references = 100, id_type = "pmid")
}
\arguments{
\item{x}{String (character vector of length 1) including a List
of references obtained from a PubMed record.}

\item{max_references}{Numeric (of length 1). Maximum number of references 
to extract/include. This should be an integer `>=0`.}

\item{id_type}{String (character vector of length 1). Type of identifier 
to be used for references. One of the following values is expected: 
`c('pmid', 'doi', 'pmc')`.}
}
\value{
data.frame including one row for each author and n=4 columns:
lastname, forename, address and email.
}
\description{
Extract Reference Information form a raw XML string, typically 
extracted from a PubMed record. Users can select the type of identifier
to extract and return, as well as the maximum number of references to 
be returned.
}
\examples{
ref <- paste0('<xml><Reference><Citation>',
              '<ArticleId IdType=\"pubmed\">25822800</ArticleId>',
              '<ArticleId IdType=\"pmc\">PMC4739640</ArticleId>',
              '</Citation></Reference></xml>')
easyPubMed:::EPM_reference_parse(ref)
easyPubMed:::EPM_reference_parse(ref, id_type = 'pmc')

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
