% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eclipseplot.R
\name{eclipsedf}
\alias{eclipsedf}
\title{Data Cleanning Helper for Eclipse Plot}
\usage{
eclipsedf(df)
}
\arguments{
\item{df}{A data frame to be cleaned.}
}
\value{
A standardized data frame with specific categorical levels ("Definitely Low", "Probably Low",
"Probably High", and "Definitely High") and column names (itemX_stepY) for use in the eclipse plot.
}
\description{
Standardizes both column names and cell values to ensure compatibility with
the 'eclipseplot' engine. It uses fuzzy matching via regular expressions to
identify headers and a robust dictionary to map various shorthand judgments
into the four standard risk-of-bias levels.
}
\details{
\strong{Column Name Standardization:}
The function identifies columns regardless of case and replaces them with:
\itemize{
  \item \code{study}: Matches "study", "article", "label", "paper", or "estudo".
  \item \code{pmid}: Matches "pmid", "pm_id", "pm id", "article id", "article_id", or "id".
  \item \code{itemX_stepY}: Matches any string containing "item" followed by a number
  and "step" followed by a number (e.g., "Item 1, Step 2" becomes "item1_step2").
}

\strong{Value Standardization (Fuzzy Mapping):}
Judgment inputs are converted to lowercase and trimmed of whitespace.
The mapping logic is as follows:
\itemize{
  \item \strong{"Definitely Low"}: Result for "definitely yes", "definitely low", "dy", "dl", "yes", or "y".
  \item \strong{"Probably Low"}: Result for "probably yes", "probably low", "py", or "pl".
  \item \strong{"Probably High"}: Result for "probably no", "probably high", "pn", "ph", or "probably-no".
  \item \strong{"Definitely High"}: Result for "definitely no", "definitely high", "dn", "dh", "no", or "n".
  \item \strong{"Not applicable"}: Assigned to any other value, including empty cells (NA) or unrecognized text.
}
}
\note{
For the purposes of the 'eclipseplot' function, there is no distinction between
the internal mapping of Step 1 and Step 2 values. Both are standardized using
the Step 2 visual scheme (color palette) to ensure a cohesive graphical
representation, as the underlying directional logic remains the same.

#' @example
data(messy)
view(messy)
organized <- eclipsedf(messy)
view(organized)
}
