% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_processing.R
\name{process_occurrences}
\alias{process_occurrences}
\title{Process occurrence data}
\usage{
process_occurrences(data, remove_duplicates = TRUE, buffer_km = 1)
}
\arguments{
\item{data}{A data frame containing at least the columns "species", "longitude", and "latitude".}

\item{remove_duplicates}{Logical. If TRUE, remove exact duplicates of species + coordinates.}

\item{buffer_km}{The buffer size in kilometers used to filter out close points.}
}
\value{
An sf object with the processed occurrences.
}
\description{
This function processes species occurrence data by optionally removing duplicates and filtering out
points that are closer than a specified distance (buffer).
}
\examples{
# Example data
occ_data <- data.frame(
  species = c("SpA", "SpA", "SpB", "SpB"),
  longitude = c(-50, -50.0005, -51, -51.001),
  latitude = c(-10, -10.0005, -11, -11.001)
)

processed <- process_occurrences(
  data = occ_data,
  remove_duplicates = TRUE,
  buffer_km = 1
)
processed
}
