% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_types.R
\name{eg_write_file}
\alias{eg_write_file}
\alias{eg_write_csv}
\alias{eg_write_delim}
\alias{eg_write_xpt}
\alias{eg_write_stata}
\alias{eg_write_spss}
\alias{eg_write_excel}
\alias{eg_write_rds}
\title{Write Data Files to Egnyte}
\usage{
eg_write_csv(x, path, overwrite = FALSE, ...)

eg_write_delim(x, path, delim = "\\t", overwrite = FALSE, ...)

eg_write_xpt(x, path, overwrite = FALSE, ...)

eg_write_stata(x, path, overwrite = FALSE, ...)

eg_write_spss(x, path, overwrite = FALSE, ...)

eg_write_excel(x, path, overwrite = FALSE, ...)

eg_write_rds(x, path, overwrite = FALSE, compress = TRUE)
}
\arguments{
\item{x}{A data frame (or R object for \code{eg_write_rds()}) to write.
For \code{eg_write_excel()}, can also be a named list of data frames to create
multiple sheets.}

\item{path}{The Egnyte destination path (e.g., "/Shared/Data/results.csv").}

\item{overwrite}{If \code{FALSE} (default), fails if a file already exists at
\code{path}. Set to \code{TRUE} to replace existing files.}

\item{...}{Additional arguments passed to the underlying write function.}

\item{delim}{The field delimiter. Defaults to tab (\code{"\\t"}).}

\item{compress}{Compression type for RDS files. See \code{\link[=saveRDS]{saveRDS()}} for options.
Defaults to \code{TRUE}.}
}
\value{
The Egnyte path (invisibly).
}
\description{
These functions write R objects to data files and upload them to Egnyte.
Each function is a thin wrapper that writes to a temporary file using the
appropriate package, then handles the upload.
}
\details{
Each function requires an optional package to be installed:\tabular{lll}{
   Function \tab Package \tab Underlying Function \cr
   \code{eg_write_csv()} \tab readr \tab \code{\link[readr:write_delim]{readr::write_csv()}} \cr
   \code{eg_write_delim()} \tab readr \tab \code{\link[readr:write_delim]{readr::write_delim()}} \cr
   \code{eg_write_excel()} \tab writexl \tab \code{\link[writexl:write_xlsx]{writexl::write_xlsx()}} \cr
   \code{eg_write_xpt()} \tab haven \tab \code{\link[haven:read_xpt]{haven::write_xpt()}} \cr
   \code{eg_write_stata()} \tab haven \tab \code{\link[haven:read_dta]{haven::write_dta()}} \cr
   \code{eg_write_spss()} \tab haven \tab \code{\link[haven:read_spss]{haven::write_sav()}} \cr
   \code{eg_write_rds()} \tab (base R) \tab \code{\link[=saveRDS]{saveRDS()}} \cr
}


All arguments passed through \code{...} are forwarded to the underlying function.

\strong{Note on SAS files:} Haven can only write SAS transport files (.xpt), not
native SAS data files (.sas7bdat). Transport files are compatible with SAS
and can be read back with \code{\link[=eg_read_xpt]{eg_read_xpt()}} or \code{\link[haven:read_xpt]{haven::read_xpt()}}.
}
\examples{
\dontrun{
# CSV files
eg_write_csv(mtcars, "/Shared/Data/mtcars.csv")
eg_write_csv(mtcars, "/Shared/Data/mtcars.csv", overwrite = TRUE)

# Delimited files
eg_write_delim(mtcars, "/Shared/Data/mtcars.tsv")
eg_write_delim(mtcars, "/Shared/Data/mtcars.txt", delim = "|")

# Excel files
eg_write_excel(mtcars, "/Shared/Data/mtcars.xlsx")

# Multiple sheets
eg_write_excel(
  list(cars = mtcars, flowers = iris),
  "/Shared/Data/workbook.xlsx"
)

# SAS transport files
eg_write_xpt(mtcars, "/Shared/Data/mtcars.xpt")

# Stata files
eg_write_stata(mtcars, "/Shared/Data/mtcars.dta")

# SPSS files
eg_write_spss(mtcars, "/Shared/Data/mtcars.sav")

# RDS files (any R object)
eg_write_rds(my_model, "/Shared/Data/model.rds")
eg_write_rds(large_data, "/Shared/Data/data.rds", compress = "xz")
}

}
\seealso{
\itemize{
\item \code{\link[=eg_write]{eg_write()}} for uploading raw files without conversion
\item \link{eg_read_file} for reading data files from Egnyte
}
}
