% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_tensor.R
\name{image_tensor}
\alias{image_tensor}
\alias{as_image_tensor}
\title{Image Tensor: A thin wrapper around 2-4D arrays}
\usage{
as_image_tensor(x)

image_tensor(x)
}
\arguments{
\item{x}{An object to convert to or from \code{image_tensor} format.}
}
\value{
\itemize{
\item \code{as_image_tensor()}: An object of class \code{image_tensor}
\item \code{as.cimg()}: A \code{cimg} object (from imager package)
\item \verb{[.image_tensor()}: A subset of the \code{image_tensor} object. For 4D arrays
with single index, returns a 3D slice without the batch dimension.
\item \code{plot()}: Invisibly returns the input object
\item \code{print()}: Invisibly returns the input object
}
}
\description{
The \code{image_tensor} class provides a convenient way to work with image data
in tensor format. It extends the base \code{array} class and provides methods
for conversion to/from various image formats, plotting, and printing.

An \code{image_tensor} object represents image data in the format "h w c"
(height, width, channels) for single images, or "b h w c"
(batch, height, width, channels) for batches of images, which is a common
format for deep learning frameworks. It also can be a 2D array, in which
case it is treated as a black and white image and shown as such.

The main utility of wrapping image data in the \code{image_tensor} class is that
printing of the object will automatically display the image as a plot,
as long as the \code{imager} package is installed. Otherwise it will simply
print the dimension of the image.
}
\details{
The \code{image_tensor} class provides the following methods (and more):
\itemize{
\item \code{as_image_tensor()}: Generic function to convert objects to
\code{image_tensor} format. Takes in array-like objects of 2-4 dimensions.
for 2 dimensional objects, it will convert them to 3D by repeating the
data across 3 channels, essentially converting grayscale images to RGB.
\item \code{as_image_tensor.default()}: Default method that converts arrays to
\code{image_tensor}
\item \code{as_image_tensor.cimg()}: Method to convert \code{cimg} objects (from imager
package) to \code{image_tensor}
\item \code{as.cimg.image_tensor()}: Method to convert \code{image_tensor} objects back
to \code{cimg} format
\item \verb{[.image_tensor()}: Subset method for \code{image_tensor} objects
\item \code{plot.image_tensor()}: Plot method for \code{image_tensor} objects
\item \code{print.image_tensor()}: Print method for \code{image_tensor} objects
}
}
\section{Format}{

An \code{image_tensor} object is an array with dimensions in "h w c" format for
single images, or "b h w c" format for batches of images:
\itemize{
\item \strong{h}: height dimension (image height in pixels)
\item \strong{w}: width dimension (image width in pixels)
\item \strong{c}: channel dimension (RGB, only for 3D & 4D arrays)
\item \strong{b}: batch dimension (number of images, only for 4D arrays)
}
}

\section{Options}{

The following options control the default behavior of \code{image_tensor} methods:
\itemize{
\item \code{plot_image_tensor_axes}: Whether to show axes in plots (default: FALSE)
\item \code{print_image_tensor_as_plot}: Whether to print images as plots (default:
TRUE)
}
}

\examples{
# create from a matrix (grayscale)
img <- image_tensor(matrix(1:9, 3, 3))
print(img)
print(img[1:2, 1:2])

# create from a 3D array (RGB image)
img_rgb <- as_image_tensor(array(runif(27), dim = c(3, 3, 3)))
print(img_rgb)

}
