% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{info}
\alias{info}
\title{Information for IRT Model}
\usage{
info(theta, ip, est = c("MLE", "EAP"), D = 1.702)
}
\arguments{
\item{theta}{Numeric vector of ability values at which to compute test
information.}

\item{ip}{A data frame or matrix of item parameters. Columns are interpreted
in order as:
\itemize{
\item 3 columns: \code{b}, \code{a}, \code{c} (3PL, with \code{a} on the 1.702 metric),
\item 2 columns: \code{b}, \code{a} (2PL, \code{c} internally set to 0),
\item 1 column: \code{b} (1PL/Rasch, \code{a = 1}, \code{c = 0}).
}}

\item{est}{Character string indicating the estimation method:
\code{"MLE"} for maximum likelihood or \code{"EAP"} for empirical Bayes.}

\item{D}{A numeric constant representing the scaling factor of the IRT model.
Defaults to \code{1.702}.}
}
\value{
A list with:
\describe{
\item{theta}{Vector of ability values.}
\item{infoMLE}{If \code{est = "MLE"}, vector of test information at each \code{theta}.}
\item{infoEAP}{If \code{est = "EAP"}, vector of test information at each \code{theta}.}
}
}
\description{
Compute test information for a unidimensional IRT model (1PL/2PL/3PL) across
a vector of ability values.
}
\details{
Test information at each \eqn{\theta} is the sum of item information.
For \code{est = "EAP"}, this function returns
\deqn{
  I_{\mathrm{EAP}}(\theta) = I_{\mathrm{MLE}}(\theta) + 1,
}
where the additional 1 reflects the prior (population) contribution under a
standard normal prior.
}
