% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energylossall.R
\name{energylossall}
\alias{energylossall}
\title{Energy Loss Calculation (Extended Output)}
\usage{
energylossall(yt, mxt, mxpt)
}
\arguments{
\item{yt}{A tensor representing the target values.}

\item{mxt}{A tensor representing the model's stochastic predictions.}

\item{mxpt}{A tensor representing another draw of the model's stochastic predictions.}
}
\value{
A vector containing the calculated energy loss, \code{s1}, and \code{s2}.
}
\description{
This function calculates the energy loss for given tensors, similar to \code{energyloss()}. The loss is calculated
as the mean of the L2 norms between \code{yt} and \code{mxt} and between \code{yt} and \code{mxpt},
subtracted by half the mean of the L2 norm between \code{mxt} and \code{mxpt}. Unlike \code{energyloss()}, this function
also returns the prediction loss s1 = E(|yt-mxt|) and variance loss s2 = E(|mxt-mxpt'|) as part of the output.
}
\keyword{internal}
