% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filesystem.R
\name{get_report_diseases}
\alias{get_report_diseases}
\title{Get both internal and public disease lists}
\usage{
get_report_diseases(internal, public, defaults)
}
\arguments{
\item{internal}{Filepath. Path to internal disease list CSV file.}

\item{public}{Filepath. Path to public disease list CSV file.}

\item{defaults}{String vector. List of default diseases to use if
either file doesn't exist.}
}
\value{
A list with two elements:
\itemize{
\item \code{internal}: Dataframe with EpiTrax_name column
\item \code{public}: Dataframe with EpiTrax_name and Public_name columns
}
}
\description{
\code{get_report_diseases} is a convenience function that combines
\code{get_report_diseases_internal} and \code{get_report_diseases_public}.
}
\examples{
# Using default lists (when files don't exist)
default_list <- c("Measles", "Chickenpox")
disease_lists <- get_report_diseases("", "", default_list)

# Using disease list files
i_file <- system.file("tinytest/test_files/disease_lists/internal_list.csv",
                       package = "epitraxr")
p_file <- system.file("tinytest/test_files/disease_lists/public_list.csv",
                       package = "epitraxr")
disease_lists <- get_report_diseases(
  internal = i_file,
  public = p_file,
  defaults = default_list
)
}
\seealso{
\code{\link[=get_report_diseases_internal]{get_report_diseases_internal()}}, \code{\link[=get_report_diseases_public]{get_report_diseases_public()}} which this function wraps.
}
