% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filesystem.R
\name{get_report_diseases_internal}
\alias{get_report_diseases_internal}
\title{Get the internal disease list}
\usage{
get_report_diseases_internal(filepath, defaults)
}
\arguments{
\item{filepath}{Filepath. Internal disease list CSV file.}

\item{defaults}{String vector. List of default diseases to use if the
above file doesn't exist.}
}
\value{
A dataframe containing the diseases to include in the internal report
and possibly the disease groupings.
}
\description{
'get_report_diseases_internal' reads the internal list from a given CSV file or
uses the default diseases, if the file doesn't exist.
}
\details{
The provided internal disease list file must contain at least a column named
\code{EpiTrax_name} which contains EpiTrax disease names to include in the report.
The file can optionally contain a column named \code{Group_name}, which maps the
diseases in \code{EpiTrax_name} to a disease group. This is only used for reports
that include disease groupings.

See the example file here:
\code{system.file("sample_data/sample_disease_list.csv", package = "epitraxr")}
}
\examples{
# Using default list (when file doesn't exist)
default_list <- c("Measles", "Chickenpox")
disease_list <- get_report_diseases_internal("", default_list)

# Using a disease list file
list_file <- system.file("sample_data/sample_disease_list.csv",
                        package = "epitraxr")
disease_list <- get_report_diseases_internal(list_file, default_list)
}
