% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-npi.R
\name{npi_add_masking}
\alias{npi_add_masking}
\title{Masking intervention (non-pharmaceutical intervention)}
\usage{
npi_add_masking(model, preval, transmission_reduction)
}
\arguments{
\item{model}{epiworldR model.}

\item{preval}{Prevalence of masking within the population.}

\item{transmission_reduction}{Reduction in transmission probability due to masking}
}
\value{
Returns an object of class epiworld_model, where model is
substituted with the model name.
}
\description{
Masking intervention (non-pharmaceutical intervention)
}
\examples{
library(epiworldR) # for ModelSEIRCONN function
model <- ModelSEIRCONN("COVID-19", n = 1000, prevalence = 0.05,
                       contact_rate = 4, transmission_rate = 0.1,
                       incubation_days = 7, recovery_rate = 0.14)
run(model, ndays = 100, seed = 123)
npi_add_masking(model, preval = .8, transmission_reduction = .7)
}
\seealso{
Other interventions: 
\code{\link{interventions_add_all}()},
\code{\link{npi_add_school_closure}()},
\code{\link{pi_add_vaccine}()}
}
\concept{interventions}
\concept{npis}
