% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmConstraint.operator.R
\name{Dyads-ergmConstraint}
\alias{Dyads-ergmConstraint}
\alias{InitErgmConstraint.Dyads}
\title{Constrain fixed or varying dyad-independent terms}
\usage{
# Dyads(fix=NULL, vary=NULL)
}
\arguments{
\item{fix, vary}{formula with only dyad-independent terms}
}
\description{
This is an "operator" constraint that takes one or two \code{\link{ergmTerm}} dyad-independent formulas. For the terms in the \verb{vary=} formula, only those that change at least one of the terms will be allowed to vary, and all others will be fixed. If both formulas are given, the dyads that vary either for one or for the other will be allowed to vary. Note that a formula passed to \code{Dyads} without an argument name will default to \verb{fix=} .
}
\seealso{
\code{\link{ergmConstraint}} for index of constraints and hints currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmConstraint", "Dyads", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{operator}
\concept{undirected}
