% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dont_skip_doses.R
\name{dont_skip_doses}
\alias{dont_skip_doses}
\title{Prevent skipping of doses.}
\usage{
dont_skip_doses(
  parent_selector_factory,
  when_escalating = TRUE,
  when_deescalating = FALSE
)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{when_escalating}{TRUE to prevent skipping when attempting to escalate.}

\item{when_deescalating}{TRUE to prevent skipping when attempting to
deescalate.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
This method optionally prevents dose selectors from skipping doses when
escalating and / or deescalating. The default is that skipping when
escalating is prevented but skipping when deescalating is permitted, but both
of these behaviours can be altered.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
model1 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  dont_skip_doses()
fit1 <- model1 \%>\% fit('1NNN')

model2 <- get_dfcrm(skeleton = skeleton, target = target)
fit2 <- model2 \%>\% fit('1NNN')

# fit1 will not skip doses
fit1 \%>\% recommended_dose()
# But fit2 will:
fit2 \%>\% recommended_dose()

# Similar demonstration for de-escalation
model1 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  dont_skip_doses(when_deescalating = TRUE)
fit1 <- model1 \%>\% fit('1NNN 2N 3TTT')

model2 <- get_dfcrm(skeleton = skeleton, target = target)
fit2 <- model2 \%>\% fit('1NNN 2N 3TTT')

# fit1 will not skip doses
fit1 \%>\% recommended_dose()
# But fit2 will:
fit2 \%>\% recommended_dose()
}
