% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view}
\alias{view}
\title{Quick interactive table viewer (reactable)}
\usage{
view(
  data,
  page_size = 10,
  searchable = TRUE,
  filterable = TRUE,
  striped = TRUE,
  highlight = TRUE,
  compact = FALSE
)
}
\arguments{
\item{data}{A data.frame or tibble to display.}

\item{page_size}{Number of rows per page (default = 10).}

\item{searchable}{Whether to enable search (default = TRUE).}

\item{filterable}{Whether to enable column filters (default = TRUE).}

\item{striped}{Whether to show striped rows (default = TRUE).}

\item{highlight}{Whether to highlight rows on hover (default = TRUE).}

\item{compact}{Whether to use a compact layout (default = FALSE).}
}
\value{
A reactable widget rendered in the Viewer pane.
}
\description{
Quickly view a data.frame or tibble as an interactive table in the Viewer pane.
}
\examples{
view(iris)
view(mtcars, page_size = 20, striped = TRUE, filterable = TRUE)

}
