% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calledBy.R
\name{calledBy}
\alias{calledBy}
\alias{called_by}
\title{Check if a Function Was Called by Another Function}
\usage{
calledBy(fun = "exams2pdf")

called_by(fun = "exams2pdf")
}
\arguments{
\item{fun}{Character string specifying the name of the calling function to check for.
Defaults to \code{"exams2pdf"}.}
}
\value{
A logical value: \code{TRUE} if the current call was triggered by \code{fun}, otherwise \code{FALSE}.
}
\description{
Determines whether the current function call was initiated by a specified function.
This is useful for conditional behavior depending on the caller.
}
\examples{
funB <- function() { calledBy("funA") }
funA <- function() { funB() }
funA()  # Returns TRUE because funB was called by funA
}
