% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-viz.R
\name{bookdown_render}
\alias{bookdown_render}
\title{Render a bookdown into a bookdown site}
\usage{
bookdown_render(bookdown_path, overwrite = FALSE)
}
\arguments{
\item{bookdown_path}{A character string identifying the folder path
where the bookdown report files are.}

\item{overwrite}{whether to overwrite existing files. FALSE by default.}
}
\value{
A folder containing htlm files (in docs, ...) generated from a bookdown
report.
}
\description{
This helper function renders an existing bookdown folder (containing at
least 'index.Rmd file)
}
\examples{
{

bookdown_path = tempdir()
bookdown_template(bookdown_path, overwrite = TRUE)
bookdown_render(bookdown_path, overwrite = TRUE)

}

}
\seealso{
\code{\link[=bookdown_template]{bookdown_template()}},\code{\link[=bookdown_open]{bookdown_open()}}
}
