% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feeplot.R
\name{feeplot}
\alias{feeplot}
\title{Plot First-Exposure Effect Distribution}
\usage{
feeplot(model, data, maxpred, ylimit, cex = 1.5, lwd = 1.5, ...)
}
\arguments{
\item{model}{A fitted object of class \code{"oneinflmodel"}.}

\item{data}{A data frame containing the original data used to fit the model.}

\item{maxpred}{Optional integer indicating the maximum count value to include on the x-axis.
Defaults to the maximum observed value in \code{data}.}

\item{ylimit}{Optional numeric value specifying the upper limit of the y-axis.
Defaults to 110\% of the maximum observed count frequency.}

\item{cex}{A numeric value for point size in the overlay plot. Defaults to \code{1.5}.}

\item{lwd}{A numeric value for line width in the overlay plot. Defaults to \code{1.5}.}

\item{...}{Additional arguments passed to \code{points()} or \code{lines()}.}
}
\value{
A barplot with overlaid predicted values from the factual and counterfactual
distributions, including a legend identifying each component.
}
\description{
Creates a bar plot of the observed count data overlaid with fitted values from
a \code{oneinfl} model and its associated counterfactual (non-inflated) model.
}
\details{
The factual predictions come from the fitted \code{oneinfl} model, while the 
counterfactual distribution is obtained by transforming the model into a non-inflated
counterpart using the same estimated parameters.


The function detects whether the model is based on a Poisson or negative binomial
distribution and selects the appropriate counterfactual model.
}
\examples{
df <- data.frame(x = runif(10,0,10), d = sample(c(0,1), 10, replace=TRUE), y = rpois(10, 3) + 1)
model <- oneinfl::oneinfl(formula = y ~ x + d | x + d, df = df, dist = "Poisson")
feeplot(model, data = df)

}
\seealso{
\code{\link{feepred}}, \code{\link{fee}}, \code{\link{dfee}}
}
