% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_if.R
\name{flag_if}
\alias{flag_if}
\alias{flag_if.default}
\alias{flag_if.data.frame}
\title{Flag if a vector or dataframe-column meets a condition.}
\usage{
flag_if(.data, ...)

\method{flag_if}{default}(.data, predicate, condition = warning, msg = NULL, ...)

\method{flag_if}{data.frame}(.data, name, predicate, condition = warning, msg = NULL, ...)
}
\arguments{
\item{.data}{Vector.}

\item{...}{Other arguments passed to methods.}

\item{predicate}{A predicate function.}

\item{condition}{A condition function (e.g. \code{\link[=stop]{stop()}}, \code{\link[=warning]{warning()}},
\code{rlang::inform()}).}

\item{msg}{String. An optional custom message.}

\item{name}{String. The name of a column of a dataframe.}
}
\value{
A condition (and \code{.data} invisibly).
}
\description{
This function returns a condition (error, warning, or message) and its first
argument, invisibly. It is a generic. If the first input is a vector, it
evaluates it directly; if it is is a dataframe, it evaluates a given column.
}
\examples{
# WITH VECTORS
dupl <- c(1, 1)
flag_if(dupl, is_duplicated)
# Silent
flag_if(dupl, is_multiple)

mult <- c(1, 2)
flag_if(mult, is_multiple, message, "Custom")
# Silent
flag_if(mult, is_duplicated)

# Both silent
flag_if(c(1, NA), is_multiple)
flag_if(c(1, NA), is_duplicated)

# WITH DATAFRAMES
.df <- data.frame(a = 1:3, b = 1, stringsAsFactors = FALSE)
flag_if(.df, "b", is_multiple)
flag_if(.df, "a", is_multiple)
flag_if(.df, "a", is_multiple, message, "Custom")
}
\seealso{
Other functions for internal use in other fgeo packages: 
\code{\link{guess_plotdim}()},
\code{\link{is_multiple}()}
}
\concept{functions for internal use in other fgeo packages}
\concept{functions to throw conditions}
\keyword{internal}
