% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guard_oidc.R
\name{GuardOIDC}
\alias{GuardOIDC}
\title{R6 class for the OpenID Connect guard}
\description{
This class encapsulates the logic of the OpenID Connect based authentication
scheme. See \code{\link[=guard_oidc]{guard_oidc()}} for more information
}
\examples{
# Example using Google endpoint (use `guard_google()` in real code)
google <- GuardOIDC$new(
  service_url = "https://accounts.google.com/",
  redirect_url = "https://example.com/auth",
  client_id = "MY_APP_ID",
  client_secret = "SUCHASECRET"
)

}
\section{Super classes}{
\code{\link[fireproof:Guard]{fireproof::Guard}} -> \code{\link[fireproof:GuardOAuth2]{fireproof::GuardOAuth2}} -> \code{GuardOIDC}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{open_api}}{An OpenID compliant security scheme description}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GuardOIDC-new}{\code{GuardOIDC$new()}}
\item \href{#method-GuardOIDC-clone}{\code{GuardOIDC$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="Guard" data-id="forbid_user"><a href='../../fireproof/html/Guard.html#method-Guard-forbid_user'><code>fireproof::Guard$forbid_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="GuardOAuth2" data-id="check_request"><a href='../../fireproof/html/GuardOAuth2.html#method-GuardOAuth2-check_request'><code>fireproof::GuardOAuth2$check_request()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="GuardOAuth2" data-id="refresh_token"><a href='../../fireproof/html/GuardOAuth2.html#method-GuardOAuth2-refresh_token'><code>fireproof::GuardOAuth2$refresh_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="GuardOAuth2" data-id="register_handler"><a href='../../fireproof/html/GuardOAuth2.html#method-GuardOAuth2-register_handler'><code>fireproof::GuardOAuth2$register_handler()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="GuardOAuth2" data-id="reject_response"><a href='../../fireproof/html/GuardOAuth2.html#method-GuardOAuth2-reject_response'><code>fireproof::GuardOAuth2$reject_response()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardOIDC-new"></a>}}
\if{latex}{\out{\hypertarget{method-GuardOIDC-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardOIDC$new(
  service_url,
  redirect_url,
  client_id,
  client_secret,
  grant_type = c("authorization_code", "password"),
  oauth_scopes = c("profile"),
  request_user_info = FALSE,
  validate = function(info) TRUE,
  redirect_path = get_path(redirect_url),
  on_auth = replay_request,
  service_name = service_url,
  service_params = list(),
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{service_url}}{The url to the authentication service}

\item{\code{redirect_url}}{The URL the authorization server should redirect to
following a successful authorization. Must be equivalent to one provided
when registering your application}

\item{\code{client_id}}{The ID issued by the authorization server when
registering your application}

\item{\code{client_secret}}{The secret issued by the authorization server when
registering your application. Do NOT store this in plain text}

\item{\code{grant_type}}{The type of authorization scheme to use, either
\code{"authorization_code"} or \code{"password"}}

\item{\code{oauth_scopes}}{Optional character vector of scopes to request the
user to grant you during authorization. These will \emph{not} influence the
scopes granted by the \code{validate} function and fireproof scoping. If named,
the names are taken as scopes and the elements as descriptions of the scopes,
e.g. given a scope, \code{read}, it can either be provided as \code{c("read")} or
\code{c(read = "Grant read access")}}

\item{\code{request_user_info}}{Logical. Should the userinfo endpoint be followed to
add information about the user not present in the JWT token. Setting this to
\code{TRUE} will add an additional API call to your authentication flow but
potentially provide richer information about the user.}

\item{\code{validate}}{Function to validate the user once logged in. It must
have a single argument \code{info}, which gets the information of the user as
provided by the \code{user_info} function in the. By default it returns \code{TRUE}
on everything meaning that anyone who can log in with the provider will
be accepted, but you can provide a different function to e.g. restrict
access to certain user names etc.}

\item{\code{redirect_path}}{The path that should capture redirects after
successful authorization. By default this is derived from \code{redirect_url}
by removing the domain part of the url, but if for some reason this
doesn't yields the correct result for your server setup you can overwrite
it here.}

\item{\code{on_auth}}{A function which will handle the result of a successful
authorization. It must have four arguments: \code{request}, \code{response},
\code{session_state}, and \code{server}. The first contains the current request
being responded to, the second is the response being send back, the third
is a list recording the state of the original request which initiated the
authorization (containing \code{method}, \code{url}, \code{headers}, and \code{body} fields
with information from the original request). By default it will use
\link{replay_request} to internally replay the original request and send back
the response.}

\item{\code{service_name}}{The name of the service provider. Will be passed on to
the \code{provider} slot in the user info list}

\item{\code{service_params}}{A named list of additional query params to add to
the url when constructing the authorization url in the
\code{"authorization_code"} grant type}

\item{\code{name}}{The name of the scheme instance. This will also be the name
under which token info and user info is saved in the session store}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardOIDC-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GuardOIDC-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardOIDC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
