% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{samplestats}
\alias{samplestats}
\title{Statistics for each F1 sample over all markers}
\usage{
samplestats(chk, scores, F1, qall_flavor="qall_mult",
qall_threshold=0, ploidy, ploidy2, scores_long=TRUE)
}
\arguments{
\item{chk}{a data frame as returned by checkF1}

\item{scores}{A data frame as read from the scores file produced by function
fitMarkers of package fitPoly (or a subset with at least columns
MarkerName, SampleName and geno), or a data frame as returned by function
scores2wide. In the first case (default) parameter scores_long must be TRUE,
in the second case it must be FALSE.}

\item{F1}{character vector with the sample names of the F1 individuals}

\item{qall_flavor}{which quality parameter column must be shown in compfile,
default "qall_mult". If no quality data are wanted, specify "".}

\item{qall_threshold}{only markers with a qall score > qall.threshold are
included in the tabulation}

\item{ploidy}{the ploidy of parent 1 (must be even, 2 (diploid) or larger),
and the same as used by checkF1 to calculate the chk data frame}

\item{ploidy2}{the ploidy of parent 2. If omitted it is assumed to be equal
to ploidy. Should be the same as used by checkF1 to calculate the chk
data frame}

\item{scores_long}{TRUE if scores is in "long format", FALSE if it is in
"wide format" (see parameter scores)}
}
\value{
A matrix with samples in rows and 3 columns: missing, invalid, valid,
giving for each sample the number of markers where it has a missing, invalid
or valid dosage score
}
\description{
Tabulate for each F1 sample in how many markers it has a
missing, invalid or valid score.
}
