% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{selMarkers_qall}
\alias{selMarkers_qall}
\title{Sample markers at several qall levels}
\usage{
selMarkers_qall(chk, qall_levels, mrkperlevel=1,
qall_flavor="qall_mult")
}
\arguments{
\item{chk}{a data frame as returned by checkF1}

\item{qall_levels}{a numeric vector with the levels of the quality
parameter (qall_mult or qall_weights, see parameter qall_flavo)
at which markers should be selected}

\item{mrkperlevel}{the number of markers to select per level of qall}

\item{qall_flavor}{which qall to use: by default qall_mult,
also qall_weights is possible}
}
\value{
A subset of data frame chk with selected rows, in ascending order
of the qall_flavor column. The first <mrkperlevel> markers with qall >=
each qall.level are returned; duplicated selections are removed (so the
number of returned markers may be less than
length(qall_levels) * mrkperlevel)
}
\description{
In order to get an idea of the quality of markers with
different levels of qall, this function samples marker numbers at a
specified set of qall values.
}
