% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{writeDosagefile}
\alias{writeDosagefile}
\title{Write a file with segregation types and dosage scores}
\usage{
writeDosagefile(chk, scores, parent1, parent2, F1,
ancestors=character(0), other=character(0),
polysomic=TRUE, disomic=FALSE, mixed=FALSE,
ploidy, ploidy2, shiftParents, scorefile)
}
\arguments{
\item{chk}{data frame as returned by checkF1}

\item{scores}{data frame as read from the scores file produced by function
fitMarkers of package fitPoly (or a subset with at least columns
MarkerName, SampleName and geno)}

\item{parent1}{character vector with the sample names of parent 1}

\item{parent2}{character vector with the sample names of parent 2}

\item{F1}{character vector with the sample names of the F1 individuals}

\item{ancestors}{character vector with the sample names of any other
ancestors}

\item{other}{other samples that should be treated like the F1}

\item{polysomic}{TRUE or FALSE; should be the same as used by checkF1
to calculate the chk data frame}

\item{disomic}{TRUE or FALSE; should be the same as used by checkF1
to calculate the chk data frame}

\item{mixed}{TRUE or FALSE; should be the same as used by checkF1
to calculate the chk data frame}

\item{ploidy}{the ploidy of parent 1 (must be even, 2 (diploid) or larger)
and the same as used by checkF1 to calculate the chk data frame}

\item{ploidy2}{the ploidy of parent 2. If omitted it is assumed to be equal
to ploidy. Should be the same as used by checkF1 to calculate the chk
data frame}

\item{shiftParents}{if there is a column shift in chk the F1 dosages will be
shifted. If shiftParents is TRUE the parents and ancestors will be shifted
together with the F1, if FALSE only the F1 will be shifted in that case.\cr
If shiftParents is missing
or NA it will be set to TRUE except if ploidy2 != ploidy:
in that case this will result in an error (because it
may be that the parents are not genotyped or scored together with the
F1, the user should specify explicitly what to do)}

\item{scorefile}{filename for tab-separated text file with the dosages,;
if NA no file is written. For details of the contents see the return value}
}
\value{
A data frame with columns:
\itemize{
\item{MarkerName: the name of the marker}
\item{segtype: the segregation type}
\item{parental and ancestor samples: the dosages of those samples}
\item{parent1: the consensus dosage for parent1 as determined by checkF1}
\item{parent2: the consensus dosage for parent2 as determined by checkF1}
\item{F1 samples: the dosages for those samples}
\item{other samples: the dosages for those samples}
}
}
\description{
Write a file with for each marker the segregation type and the
dosage scores of the parental and ancestor samples, the parental consensus
dosages and the F1 samples.
}
