% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/004b_ms_flat_2tail.R
\name{ms_flat_2tail}
\alias{ms_flat_2tail}
\title{Illustration of Model Selection Among 18 Distributions from the \code{fitdistcp} Package}
\usage{
ms_flat_2tail(x)
}
\arguments{
\item{x}{data vector}
}
\value{
Plots QQ plots to the screen, for each of the models,
and returns a data frame containing
\itemize{
\item AIC scores (times -0.5), AIC weights
\item  WAIC1 scores, WAIC1 weights
\item WAIC2 scores, WAIC2 weights
\item logscores, logscore weights
\item maximum likelihood and calibrating prior means
\item maximum likelihood and calibrating prior standard deviations
}
}
\description{
Applies model selection using AIC, WAIC1, WAIC2 and leave-one-out logscore
to the input data \eqn{x},
for 7 two tailed models in the \code{fitdistcp} packages

The code is straightforward, and the point is to illustrate what is
possible using the model selection outputs from the \code{fitdistcp} routines.
}
\details{
The 7 models are:
\code{norm},
\code{gnorm_k3},
\code{gumbel},
\code{logis},
\code{lst_k3},
\code{cauchy},
\code{gev}
}
\examples{
\donttest{ # because it's too slow for CRAN
set.seed(1)
nx=50
x=rnorm(nx)
print(ms_flat_2tail(x))
}


}
\author{
Stephen Jewson \email{stephen.jewson@gmail.com}
}
