% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_functions.R
\name{build_scree_plot}
\alias{build_scree_plot}
\title{Build Scree Plot for Configural Invariance}
\usage{
build_scree_plot(fpca_A, fpca_B, groups)
}
\arguments{
\item{fpca_A}{An \code{fpca.sc} object for Group A.}

\item{fpca_B}{An \code{fpca.sc} object for Group B.}

\item{groups}{A character vector of the two group names.}
}
\value{
A ggplot object.
}
\description{
Creates a ggplot2 scree plot comparing the PVE by FPCs for
two groups.
}
\examples{
\donttest{
  sim <- simulate_fmi_data(N_A = 20, N_B = 20, T_points = 30)
  g_fac <- factor(sim$group_vec)
  idx_A <- which(g_fac == levels(g_fac)[1])
  # --- FIX: Added Y= and argvals= ---
  fpca_A <- refund::fpca.sc(Y = sim$Y_mat[idx_A, ], argvals = sim$argvals, npc = 3)
  fpca_B <- refund::fpca.sc(Y = sim$Y_mat[-idx_A, ], argvals = sim$argvals, npc = 3)
  build_scree_plot(fpca_A, fpca_B, levels(g_fac))
}
}
