% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataInputChecker.R
\name{create_clim}
\alias{create_clim}
\title{Create foreSIGHT reference climate object from time information and climate data.}
\usage{
create_clim(timeStart, timeEnd, timeStep, fmt = NULL, tz = "UTC", ...)
}
\arguments{
\item{timeStart}{a character; the first time for the climate data}

\item{timeEnd}{a character; the last time}

\item{timeStep}{a character; the time step, containing one of "hour", "day", "week", "month" or "year"}

\item{fmt}{a character; format of \code{timeStart} and \code{timeEnd}}

\item{tz}{a character; the timezone. Default is 'UTC', which avoids issues with daylight savings.}

\item{...}{vectors or matrices; climate data objects which will be added to the output list.}
}
\value{
The function returns a list containing \code{times} in POSIXct format and climate data.
}
\description{
\code{create_clim} produces reference climate data list.
}
\examples{
# create small reference climate list (only 10 days)
clim <- create_clim(
  timeStart = "2007/01/01", # start date
  timeEnd = "2007/01/10", # end date
  timeStep = "day", # time step
  fmt = "\%Y/\%m/\%d", # format of start/end dates
  P = c(0, 0, 0, 0, 0, 4.5, 2.6, 0, 0, 0), # precip data
  Temp = c(25, 24, 30, 32, 33, 27, 21, 21, 22, 30) # temperature data
)
}
