% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frailtyIllnessDeath.R
\name{frailtyIllnessDeath}
\alias{frailtyIllnessDeath}
\title{Fit a Weibull Illness-Death Model with Optional Shared Frailty}
\usage{
frailtyIllnessDeath (formula, formula.terminalEvent, data, model = "Semi-Markov",
maxit = 300, init.B, init.Theta, init.hazard.weib,
LIMparam = 1e-3, LIMlogl = 1e-3, LIMderiv = 1e-3,
partialH, x01, x02, x12, print.info = FALSE,
print.result = TRUE, blinding = TRUE)
}
\arguments{
\item{formula}{A formula object with the response on the left of a \eqn{\sim}
operator, and the terms on the right. The response must be a survival object
as returned by the 'Surv' function. Status should be 1 if event 0->1 occurred,
0 otherwise. Covariates for transition 0->1 are specified here. Shared frailty
is specified using \code{cluster(group_variable)}. Left truncation can be
included via \code{Surv(time1, time2, status)}.}

\item{formula.terminalEvent}{A formula object. Response must be a \code{survival::Surv} object
 representing the time and status for the terminal event (death). Status should be 1 if
 transition to state 2 occurred (either from state 0 or state 1), 0 otherwise (censored). Covariates for
 transitions 0->2 and 1->2 are specified on the RHS (currently assumes the same covariates
 apply to both 0->2 and 1->2). 

\strong{Note on Left Truncation:} The illness-death model implemented assumes a
\strong{single entry time} per subject. This entry time, specified in \code{formula},
indicates that the subject must be in the initial state (state 0, having experienced
neither transition 0->1 nor 0->2) at that \code{entry_time} to be included
in the analysis. The entry time should \strong{not} be specified again here in
\code{formula.terminalEvent}.}

\item{data}{A 'data.frame' with the variables used in the formulas.}

\item{model}{Character string specifying the model for the 1->2 transition
baseline hazard. Allowed values: "Semi-Markov" (default) or "Markov".}

\item{maxit}{Maximum number of iterations for the Marquardt algorithm.
Default is 300.}

\item{init.B}{Optional. A vector of initial values for regression coefficients.
Order is (\eqn{\beta_1},\eqn{\beta_2},\eqn{\beta_3}). 
The total length must match the total number of regression coefficients. 
If omitted, the regression coefficients are initialized from default values. 
These defaults are obtained by fitting three independent Weibull proportional 
hazards models (without frailty), one for each transition.}

\item{init.Theta}{Optional. Initial value for the frailty variance \eqn{\theta}.
Default is 0.1. This parameter is only used if \code{cluster()} is present
in \code{formula}.}

\item{init.hazard.weib}{Optional. A vector of initial values for the Weibull baseline
hazard parameters. Must be of size 6, in the order: scale(0->1),
shape(0->1), scale(0->2), shape(0->2), scale(1->2), shape(1->2).
If omitted, the baseline hazard parameters are initialized from default values. 
These defaults are obtained by fitting three independent Weibull proportional 
hazards models (without frailty), one for each transition.}

\item{LIMparam}{Convergence threshold for the parameters based on the maximum
absolute difference between successive iterations (\eqn{10^{-3}} by default).}

\item{LIMlogl}{Convergence threshold for the log-likelihood based on the absolute
difference between successive iterations (\eqn{10^{-3}} by default).}

\item{LIMderiv}{Convergence threshold based on the relative distance to the optimum
(related to gradient and Hessian) (\eqn{10^{-3}} by default). See Details.}

\item{partialH}{Optional. Integer vector specifying the indices of parameters to
exclude from the Hessian matrix when calculating the relative distance
convergence criterion (\code{LIMderiv}). This is only considered if the first
two criteria (\code{LIMparam}, \code{LIMlogl}) are met and the full Hessian
is problematic (e.g., not invertible). Default is \code{NULL}.}

\item{x01}{Optional. Numeric vector of time points at which to calculate baseline
hazard and survival functions for transition 0->1. Defaults to a sequence of
99 points from 0 to the maximum observed time for transition 0->1.}

\item{x02}{Optional. Numeric vector of time points at which to calculate baseline
hazard and survival functions for transition 0->2. Defaults to a sequence of
99 points from 0 to the maximum observed time for transition 0->2.}

\item{x12}{Optional. Numeric vector of time points at which to calculate baseline
hazard and survival functions for transition 1->2. Defaults to a sequence of
99 points from 0 to the maximum observed time for transition 1->2.}

\item{print.info}{Logical. If \code{TRUE}, prints information at each iteration
of the optimization algorithm. Default is \code{FALSE}.}

\item{print.result}{Logical. If \code{TRUE}, prints a formatted summary of the
results. Default is \code{TRUE}.}

\item{blinding}{Logical. If \code{TRUE}, the algorithm attempts to continue even
if the log-likelihood calculation produces non-finite values (e.g., \code{Inf},
\code{NaN}) at some iteration. Setting to \code{FALSE} may cause the algorithm
to stop earlier in such cases. Default is \code{TRUE}.}
}
\value{
An object of class 'frailtyIllnessDeath ' containing:
\describe{
  \item{b}{Vector of the estimated parameters. Order is:
  (scale(0->1), shape(0->1), scale(0->2), shape(0->2), scale(1->2), shape(1->2),
   \eqn{\hat {\theta}} (if frailty), \eqn{\hat{\beta}_1}, \eqn{\hat{\beta}_2}, \eqn{\hat{\beta}_3}).}
  \item{call}{The matched function call.}
  \item{coef}{Vector of estimated regression coefficients.}
  \item{loglik}{The marginal log-likelihood value at the final parameter estimates.}
  \item{grad}{Gradient vector of the log-likelihood at the final parameter estimates.}
  \item{n}{The number of subjects (observations) used in the fit.}
  \item{n.events}{Vector containing the number of observed events: count for 0->1, count for 0->2, count for 1->2 and count for censoring.}
  \item{n.iter}{Number of iterations.}
  \item{vcov}{Variance-covariance matrix for the parameters listed in \code{b}.}
  \item{npar}{Total number of estimated parameters.}
  \item{nvar}{Total number of regression coefficients.}
  \item{shape.weib}{Vector of estimated Weibull baseline shape parameters (shape(0->1),shape(0->2),shape(1->2)).}
  \item{scale.weib}{Vector of estimated Weibull baseline scale parameters (scale(0->1),scale(0->2),scale(1->2)).}
  \item{crit}{Convergence status code: 1=converged, 2=maximum iterations reached, 3=converged using partial Hessian, 4=the algorithm encountered a problem in the loglikelihood computation.}
  \item{Frailty}{Logical. \code{TRUE} if a model with shared frailty (\code{cluster(.)}) was fitted.}
  \item{beta_p.value}{Vector of p-values from Wald tests for the regression coefficients in \code{coef}.}
  \item{AIC}{Akaike Information Criterion, calculated as \eqn{AIC=\frac{1}{n}(np - l(.))}, where np is the number of parameters and l is the log-likelihood.}
  \item{x01}{Vector of time points used for calculating baseline functions for transition 0->1.}
  \item{x02}{Vector of time points used for calculating baseline functions for transition 0->2.}
  \item{x12}{Vector of time points (or sojourn times if Semi-Markov) used for calculating baseline functions for transition 1->2.}
  \item{lam01}{Matrix containing baseline hazard estimates and 95\% confidence intervals for transition 0->1  calculated at \code{x01}.}
  \item{lam02}{Matrix containing baseline hazard estimates and 95\% confidence intervals for transition 0->2 calculated at \code{x02}.}
  \item{lam12}{Matrix containing baseline hazard estimates and 95\% confidence intervals for transition 1->2 calculated at \code{x12}.}
  \item{surv01}{Matrix containing baseline survival estimates and 95\% confidence intervals for transition 0->1 calculated at \code{x01}.}
  \item{surv02}{Matrix containing baseline survival estimates and 95\% confidence intervals for transition 0->2 calculated at \code{x01}.}
  \item{surv12}{Matrix containing baseline survival estimates and 95\% confidence intervals for transition 0->2 calculated at \code{x12}.}
  \item{median.01}{Matrix containing the estimated median baseline survival time and its 95\% confidence interval for transition 0->1.}
  \item{median.02}{Matrix containing the estimated median baseline survival time and its 95\% confidence interval for transition 0->2.}
  \item{median.12}{Matrix containing the estimated median baseline survival time and its 95\% confidence interval for transition 1->2.}
  \item{linear.pred01}{Vector of linear predictors calculated for transition 0->1. For non-frailty models, this is \eqn{\hat{\beta}_1^{t}X_{01}}. For frailty models, it includes the estimated log-frailty: \eqn{\hat{\beta}_1^{t}X_{01} + \log(\hat{\omega}_i).}}
  \item{linear.pred02}{Vector of linear predictors calculated for transition 0->2. For non-frailty models, this is \eqn{\hat{\beta}_2^{t}X_{02}}. For frailty models, it includes the estimated log-frailty: \eqn{\hat{\beta}_2^{t}X_{02} + \log(\hat{\omega}_i).}}
  \item{linear.pred12}{Vector of linear predictors calculated for transition 1->2. For non-frailty models, this is \eqn{\hat{\beta}_3^{t}X_{12}}. For frailty models, it includes the estimated log-frailty: \eqn{\hat{\beta}_3^{t}X_{12} + \log(\hat{\omega}_i).}}
  \item{names.factor.01}{Character vector identifying factor covariates included for transition 0->1.}
  \item{names.factor.02}{Character vector identifying factor covariates included for transition 0->2.}
  \item{names.factor.12}{Character vector identifying factor covariates included for transition 1->2.}
  \item{global_chisq.01}{Vector containing the chi-squared statistics for global Wald tests of factor variables for transition 0->1.}
  \item{global_chisq.02}{Vector containing the chi-squared statistics for global Wald tests of factor variables for transition 0->2.}
  \item{global_chisq.12}{Vector containing the chi-squared statistics for global Wald tests of factor variables for transition 1->2.}
  \item{dof_chisq.01}{Vector containing the degrees of freedom for the global Wald tests for transition 0->1.}
  \item{dof_chisq.02}{Vector containing the degrees of freedom for the global Wald tests for transition 0->2.}
  \item{dof_chisq.12}{Vector containing the degrees of freedom for the global Wald tests for transition 1->2.}
  \item{p.global_chisq.01}{Vector containing the p-values for the global Wald tests for transition 0->1.}
  \item{p.global_chisq.02}{Vector containing the p-values for the global Wald tests for transition 0->2.}
  \item{p.global_chisq.12}{Vector containing the p-values for the global Wald tests for transition 1->2.}
  \item{global_chisq.test.01}{Indicator (0/1) whether any global factor tests were performed for transition 0->1.}
  \item{global_chisq.test.02}{Indicator (0/1) whether any global factor tests were performed for transition 0->2.}
  \item{global_chisq.test.12}{Indicator (0/1) whether any global factor tests were performed for transition 1->2.}
}
If \code{Frailty} is \code{TRUE}, the following components related to frailty are also included:
\describe{
  \item{groups}{The number of unique groups specified by \code{cluster(.)}.}
  \item{theta}{The estimated variance (\eqn{\hat{\theta}}) of the Gamma frailty distribution.}
  \item{theta_p.value}{The p-value from a Wald test for the null hypothesis \eqn{H_0: \theta=0}.}
  \item{VarTheta}{The estimated variance of the frailty variance estimator: \eqn{\hat{Var}(\hat{\theta})}.}
  \item{frailty.pred}{Vector containing the empirical Bayes predictions of the frailty term for each group.}
  \item{frailty.var}{Vector containing the variances of the empirical Bayes frailty predictions.}
  \item{frailty.sd}{Vector containing the standard errors of the empirical Bayes frailty predictions.}
}
}
\description{
Fit a three-state illness-death model (states: 0=Healthy, 1=Illness, 2=Death)
using Weibull baseline hazards for all transitions (0->1, 0->2, 1->2).
Allows for shared gamma frailty between the three transitions, acting
multiplicatively on the hazards within specified groups (clusters).
The model accommodates right-censored and left-truncated data.
The transition from the illness state to death (1->2) can be modeled using
either a Markov or a Semi-Markov assumption for the baseline hazards time scale.

\if{html}{
\figure{IDSCHEME.png}{options: width="329"}
}

\if{latex}{
\figure{IDSCHEME.png}{options: width=8.7cm}
}
}
\details{
Let \eqn{T_1} be the time to the non-terminal event (illness, 0->1) and
\eqn{T_2} be the time to the terminal event (death, 0->2 or 1->2).

The transition intensities are defined as:
\deqn{
  \lambda_{01}(t) = \lim_{\Delta t \to 0^+} \frac{\mathbb{P}(t \leq T_1 \leq t + \Delta t \mid T_1 \geq t, T_2 \geq t)}{\Delta t}}

\deqn{
  \lambda_{02}(t) = \lim_{\Delta t \to 0^+} \frac{\mathbb{P}(t \leq T_2 \leq t + \Delta t \mid T_1 \geq t, T_2 \geq t)}{\Delta t}}

\deqn{
  \lambda_{12}(t \mid T_1 = s) = \lim_{\Delta t \to 0^+} \frac{\mathbb{P}(t \leq T_2 \leq t + \Delta t \mid T_1 = s, T_2 \geq t)}{\Delta t} \quad (0 < s < t)}

A proportional hazards model with a shared frailty term \eqn{\omega_i} is assumed
for each transition within group \eqn{i}. For the \eqn{j^{th}} subject
(\eqn{j=1,...,n_i}) in the \eqn{i^{th}} group (\eqn{i=1,...,G}) the transition intensities are
defined as follows:
\deqn{
  \lambda_{01}^{ij}(t |\omega_i,X_{01}^{ij}) = \lambda_{0,01}(t) \omega_i \exp(\beta_1^{T} X_{01}^{ij})
}
\deqn{
  \lambda_{02}^{ij}(t |\omega_i,X_{02}^{ij}) = \lambda_{0,02}(t) \omega_i \exp(\beta_2^{T} X_{02}^{ij})
}
\deqn{
  \lambda_{12}^{ij}(t | T_1 = s, \omega_i, X_{12}^{ij}) = \lambda_{0,12}(t | T_1 = s) \omega_i \exp(\beta_3^{T} X_{12}^{ij}) \quad (0 < s < t)
}
\eqn{\omega_i} is the frailty term for the \eqn{i^{th}} group.
For subject-specific frailties, use \code{cluster(id)} where id is unique (\eqn{n_i=1}).

\eqn{\beta_1}, \eqn{\beta_2} and \eqn{\beta_3} are respectively the vectors 
of time fixed regression coefficients for the transitions 0->1, 0->2 and 1->2.
\eqn{X_{01}^{ij}}, \eqn{X_{02}^{ij}} and \eqn{X_{12}^{ij}} are respectively the vectors 
of time fixed covariates for the \eqn{j^{th}} subject in the \eqn{i^{th}} group for the 
transitions 0->1, 0->2 and 1->2.
\eqn{\lambda_{0,01}(.)}, \eqn{\lambda_{0,02}(.)} and \eqn{\lambda_{0,12}(.)} are respectively
 the baseline hazard functions for the transitions 0->1, 0->2 and 1->2.

  The baseline hazard \eqn{\lambda_{0,12}(t | T_1 = s)} depends on the 'model' argument:
  \itemize{
  \item \bold{Markov model}: \eqn{\lambda_{0,12}(t | T_1 = s) = \lambda_{0,12}(t)}. 
  The risk depends on the time since origin.This model is suitable when the risk for
   the transition 1 -> 2 is primarily influenced by absolute time rather than the duration spent in state 1.
   
  \item \bold{Semi-Markov model}: \eqn{\lambda_{0,12}(t | T_1 = s) = \lambda_{0,12}(t - s)}. 
  The risk depends on the time since entering state 1 (sojourn time).
  This model is appropriate when the risk for the transition 1 -> 2  is
   more influenced by the time spent in state 1 rather than the time elapsed 
   since the initial starting point.
  }
The Weibull baseline hazard parameterization is:
\deqn{\lambda(t) = \frac{\gamma}{\lambda^\gamma} \cdot t^{\gamma - 1}} 
where \eqn{\lambda} is the scale parameter and \eqn{\gamma} the shape parameter
}
\note{
The optimization uses the robust Marquardt algorithm (Marquardt, 1963),
combining Newton-Raphson and steepest descent steps. Iterations stop when
criteria \code{LIMparam}, \code{LIMlogl}, and \code{LIMderiv} are all met.
Confidence bands for the baseline hazard and baseline survival functions were 
computed using a Monte Carlo simulation approach based on the estimated Weibull 
parameters. A sample of size 1000 was drawn from the joint distribution of the 
shape and scale parameters. For each sampled parameter set, the baseline functions 
were evaluated over the time grid defined by the vector \code{x0}. Pointwise 95% 
confidence bands were then obtained by computing the 2.5th and 97.5th percentiles 
of the simulated values at each time point for each baseline function.
}
\examples{
\donttest{
 
data(readmission2)

##-- Fitting models --##

#-- Semi-Markovian Weibull Illness-Death model with 
#   group frailty shared between transitions --#

ModIllnessDeath_SemiMarkov_Group <- frailtyIllnessDeath(
  formula = Surv(observed_disease_time, disease_status) ~ cluster(group) + sex,
  formula.terminalEvent = Surv(observed_death_time, death_status) ~ sex,
  data        = readmission2,
  model       = "Semi-Markov",
  print.info  = FALSE,
  maxit       = 100
)

#-- Markovian Weibull Illness-Death model with subject-specific 
#   frailty shared between transitions --#

ModIllnessDeath_Markov_Subject <- frailtyIllnessDeath(
  formula = Surv(observed_disease_time, disease_status) ~ cluster(id) + sex,
  formula.terminalEvent = Surv(observed_death_time, death_status) ~ sex,
  data        = readmission2,
  model       = "Markov",
  print.info  = FALSE,
  maxit       = 100
)

#--- Semi-Markovian Weibull Illness-Death model with a factor and 
#    no covariates for the non-terminal event ---#

ModIllnessDeath_SemiMarkov_NoCov_Factor <- frailtyIllnessDeath(
  formula = Surv(observed_disease_time, disease_status) ~ 1,
  formula.terminalEvent = Surv(observed_death_time, death_status) ~ factor(dukes),
  data        = readmission2,
  model       = "Semi-Markov",
  print.info  = FALSE,
  maxit       = 100
)

#--- Semi-Markovian Weibull Illness-Death model with left truncation ---#

data(Paq810)

ModIllnessDeath_SemiMarkov_LeftTrunc <- frailtyIllnessDeath(
  formula = Surv(e, r, dementia) ~ gender + certif,
  formula.terminalEvent = Surv(t, death) ~ certif,
  data        = Paq810,
  model       = "Semi-Markov",
  print.info  = FALSE,
  maxit       = 100
)

#--- Markovian Weibull Illness-Death model with left truncation ---#

ModIllnessDeath_Markov_LeftTrunc <- frailtyIllnessDeath(
  formula = Surv(e, r, dementia) ~ gender + certif,
  formula.terminalEvent = Surv(t, death) ~ certif,
  data        = Paq810,
  model       = "Markov",
  print.info  = FALSE,
  maxit       = 100
) }

}
\references{
Lee, C., Gilsanz, P., & Haneuse, S. (2021). Fitting a shared frailty
illness-death model to left-truncated semi-competing risks data
to examine the impact of education level on incident dementia.
\emph{BMC Medical Research Methodology}, 21(1), 1-13.

Marquardt, D. W. (1963). An algorithm for least-squares estimation of nonlinear
parameters. \emph{SIAM Journal on Applied Mathematics}, 11(2), 431-441.

Liquet, B., Timsit, J. F., & Rondeau, V. (2012). Investigating hospital
heterogeneity with a multi-state frailty model: application to nosocomial
pneumonia disease in intensive care units. \emph{BMC Medical Research
Methodology}, 12(1), 1-14.
}
