% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_notebook.R
\name{make_rmd}
\alias{make_rmd}
\title{Create an RMarkdown Notebook}
\usage{
make_rmd(name, dir = NULL, stub = "default", overwrite = FALSE, subdir = NULL)
}
\arguments{
\item{name}{Character. The file name (with or without .Rmd extension)}

\item{dir}{Character. Directory to create the file in. Uses your project's
configured \code{directories$notebooks} setting. Default: "notebooks/".}

\item{stub}{Character. Name of the stub template to use. Default "default".}

\item{overwrite}{Logical. Whether to overwrite existing file. Default FALSE.}

\item{subdir}{Optional subdirectory under \code{dir} (e.g., "analyses/exploratory").}
}
\value{
Invisible path to created notebook
}
\description{
Convenient alias for \code{make_notebook(type = "rmarkdown")}. Creates a .Rmd file
from stub templates.
}
\examples{
\donttest{
if (FALSE) {
# Create notebooks/analysis.Rmd
make_rmd("analysis")

# Use custom stub
make_rmd("report", stub = "minimal")

# Create in specific directory
make_rmd("explore", dir = "work")
}
}

}
\seealso{
\code{\link[=make_notebook]{make_notebook()}}, \code{\link[=make_qmd]{make_qmd()}}
}
