% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_weight.R
\name{read.fs.weight}
\alias{read.fs.weight}
\title{Read file in FreeSurfer weight or w format}
\usage{
read.fs.weight(filepath, format = "auto")
}
\arguments{
\item{filepath}{string. Full path to the input weight file. Weight files typically have the file extension '.w', but that is not enforced.}

\item{format}{one of 'auto', 'asc', or 'bin'. The format to assume. If set to 'auto' (the default), binary format will be used unless the filepath ends with '.asc'.}
}
\value{
the indices and weight data, as a named list. Entries: "vertex_indices": vector of *n* vertex indices. They are stored zero-based in the file, but are returned one-based (R-style). "value": double vector of length *n*, the morphometry data for the vertices. The data can be whatever you want.
}
\description{
Read morphometry data in weight format (aka `w` files). A weight format file contains morphometry data for a set of vertices, defined by their index in a surface. This can be only a **subset** of the surface vertices.
}
\seealso{
Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.curv}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.volume}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.morph.asc}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.morph.ni1}()},
\code{\link{write.fs.morph.ni2}()},
\code{\link{write.fs.morph.smp}()},
\code{\link{write.fs.morph.txt}()},
\code{\link{write.fs.weight}()},
\code{\link{write.fs.weight.asc}()}
}
\concept{morphometry functions}
