% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmapg.R
\name{fmapg}
\alias{fmapg}
\title{Apply a function to groups of a data frame in parallel}
\usage{
fmapg(.df, .f, by, ncores = NULL, pb = FALSE, ...)
}
\arguments{
\item{.df}{A data frame to group and apply the function over.}

\item{.f}{A function to apply to each group. The function should accept a data frame (a group).}

\item{by}{A character vector of column names in `.df` used for grouping.}

\item{ncores}{Integer. Number of cores to use for parallel processing. Default is `NULL` (sequential).}

\item{pb}{Logical. Whether to show a progress bar. Default is `FALSE`.}

\item{...}{Additional arguments passed to `.f`.}
}
\value{
A list of results, one for each group defined by `by`.
}
\description{
Applies a function `.f` to each group of rows in a data frame `.df`, where grouping is defined by one or more variables in `by`.
Each group is passed as a data frame to `.f`. Supports parallelism and optional progress display.
}
\examples{
# Group-wise mean of Sepal.Length in iris dataset
fmapg(iris, function(df) mean(df$Sepal.Length), by = "Species")

# Group-wise model fitting with progress and parallelism
\donttest{
fmapg(mtcars, function(df) lm(mpg ~ wt, data = df), by = "cyl", ncores = 2, pb = TRUE)
}

}
