% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.galamm.R
\name{anova.galamm}
\alias{anova.galamm}
\title{Compare likelihoods of galamm objects}
\usage{
\method{anova}{galamm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{...}{Other fitted models of class \code{galamm}. Currently, if no
models are provided in this argument, no table will be returned.}
}
\value{
A table with model comparison metric.
}
\description{
Anova function for comparing different GALAMMs fitted on the
same data.
}
\examples{
# Poisson GLMM
count_mod <- galamm(
  formula = y ~ lbas * treat + lage + v4 + (1 | subj),
  data = epilep, family = poisson
)

# Model without interaction
count_mod0 <- galamm(
  formula = y ~ lbas + treat + lage + v4 + (1 | subj),
  data = epilep, family = poisson
)

# Model comparison
anova(count_mod, count_mod0)

}
\references{
\insertRef{batesFittingLinearMixedEffects2015}{galamm}
}
\seealso{
\code{\link[=summary.galamm]{summary.galamm()}} for the summary method and \code{\link[=anova]{anova()}} for the
generic function.

Other summary functions: 
\code{\link{draw.galamm}()},
\code{\link{plot_smooth.galamm}()},
\code{\link{print.galamm}()},
\code{\link{print.summary.galamm}()},
\code{\link{summary.galamm}()}
}
\author{
Some of the source code for this function is adapted from
\code{lme4:::anova.merMod}, with authors Douglas M. Bates, Martin Maechler,
Ben Bolker, and Steve Walker.
}
\concept{summary functions}
