% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_scale}
\alias{GC_scale}
\title{Update Scale of a GC Chart Cluster}
\usage{
GC_scale(
  GC_chart,
  cluster = NULL,
  start = NULL,
  end = NULL,
  padding = 2,
  hidden = FALSE,
  breaks = list(),
  tickValues = NULL,
  reverse = FALSE,
  axis_position = "bottom",
  axis_type = "position",
  y = NULL,
  scale_breaks = FALSE,
  scale_break_threshold = 20,
  scale_break_padding = 1,
  ticksCount = 10,
  ticksFormat = NULL,
  tickStyle = list(),
  textStyle = list(),
  lineStyle = list(),
  ...
)
}
\arguments{
\item{GC_chart}{A GC chart object.}

\item{cluster}{Numeric or character vector specifying clusters in the GC
chart to update.}

\item{start}{Numeric vector indicating the starting point for the scale.
Default is NULL.}

\item{end}{Numeric vector indicating the end point for the scale.
Default is NULL.}

\item{padding}{Numeric value or percentage string indicating the padding on
either side of the scale. The value can be a number or a string in the
format of '2\%'. Default is 2.}

\item{hidden}{Logical flag indicating whether the axis is hidden. Default is
FALSE.}

\item{breaks}{List specifying settings for the scale breaks. Default is an
empty list ().}

\item{tickValues}{Numeric vector or NULL, custom tick values to be used at
the top of the cluster. If NULL, the default tick values are used.}

\item{reverse}{Logical flag indicating whether to reverse the scale for the
corresponding cluster. Default is FALSE.}

\item{axis_position}{Character string indicating the type of the axis ('top' or
bottom'). Default is 'bottom'.}

\item{axis_type}{Character string indicating the type of the axis ('position' or
'range'). Default is 'position'.}

\item{y}{Numeric value from 1 to 100 indicating the y-position of the x-axis.
Default is NULL.}

\item{scale_breaks}{Logical flag indicating if scale breaks should be
employed. Default is FALSE.}

\item{scale_break_threshold}{Numeric value indicating the threshold
percentage for determining scale breaks. Default is 20.}

\item{scale_break_padding}{Numeric value indicating the padding on either
side of a scale break. Default is 1.}

\item{ticksCount}{Numeric value indicating the number of ticks on the scale.
Default is 10.}

\item{ticksFormat}{Format for tick labels; depends on axis_type, defaulting
to ",.0f" for 'position' or ".2s" for 'range' when NULL.}

\item{tickStyle}{List specifying the style for the ticks.}

\item{textStyle}{List specifying the style for the tick text.}

\item{lineStyle}{List specifying the style for the axis line.}

\item{...}{Additional arguments for scale settings.}
}
\value{
Updated GC chart with new scale settings.
}
\description{
Modify the scale settings for specified clusters within a GC chart.
}
\examples{
genes_data <- data.frame(
  start = c(100, 1000, 2000),
  end = c(150, 1500, 2500),
  name = c('Gene 4', 'Gene 5', 'Gene 6'),
  group = c('B', 'A', 'C'),
  cluster = c(2, 2, 2)
)
#Example usage with all custom options
GC_chart(genes_data, cluster = "cluster", group = "group", height = "200px") \%>\%
  GC_scale(
    start = 1,
    end = 2600,
    padding = 2,
    hidden = FALSE,
    reverse = FALSE,
    axis_position = "bottom",
    # breaks = list(
    #  list(start = 160, end = 900),
    #  list(start = 1600, end = 1900)
    # ),
    # tickValues = c(1, 2600),
    scale_breaks = TRUE,
    scale_break_threshold = 20,
    scale_break_padding = 1,
    ticksCount = 10,
    ticksFormat = ",.0f",
    y = NULL,
    tickStyle =
      list(
        stroke = "grey",
        strokeWidth = 1,
        lineLength = 6
        # Any other CSS styles
      ),
    textStyle =
      list(
        fill = "black",
        fontSize = "10px",
        fontFamily = "Arial",
        cursor = "default"
        # Any other CSS styles
      ),
    lineStyle = list(
      stroke = "grey",
      strokeWidth = 1
      # Any other CSS styles
    )
  ) \%>\%
  GC_legend(FALSE)
}
