\name{SB}
\alias{dSB}
\alias{pSB}
\alias{qSB}
\alias{rSB}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
The Shaw and Buckley (transmuted) distribution
}
\description{
Density, distribution function, quantile function and random generation for the Shaw and Buckley (SB) distribution.
}
\usage{
dSB(x, lambda = 0, log = FALSE)
pSB(q, lambda = 0, lower.tail = TRUE, log.p = FALSE)
qSB(p, lambda = 0, lower.tail = TRUE, log.p = FALSE)
rSB(n, lambda = 0)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x, q}{
vector of quantiles.
}
  \item{p}{
vector of probabilities.
}
  \item{n}{
number of observations. If length(n) > 1, the length is taken to be the number required.
}
\item{lambda}{
shape parameter (by default is 0).
}
\item{log, log.p}{
logical; if TRUE, probabilities p are given as log(p).
}
\item{lower.tail}{
logical; if TRUE (default), probabilities are \eqn{P[X\leq x]}, otherwise \eqn{P[X>x]}. 
}
}
\details{
The SB model has cumulative distribution function
\deqn{
F(x;\delta)=\delta x^2+(1-\delta)[1-(1-x)^2], \quad x \in (0,1), 
}
where \eqn{\delta=(1-\lambda)/2} and \eqn{\lambda \in (-1,1)}.
}
\value{
dSB gives the density, pSB gives the distribution function, qSB gives the quantile function, and rSB generates random deviates.
The length of the result is determined by n for rcompound, and is the maximum of the lengths of the numerical arguments for the other functions.
The numerical arguments other than n are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Yolanda M. Gomez, Diego I. Gallardo, Hector W. Gomez and Barry Arnold
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
set.seed(2100)
y=rSB(100, lambda = 0.7)
}

