% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSNamespaceManager.R
\docType{class}
\name{GSNamespaceManager}
\alias{GSNamespaceManager}
\title{Geoserver REST API Namespace Manager}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for managing the namespaces
 of a GeoServer instance.
}
\description{
Geoserver REST API Namespace Manager

Geoserver REST API Namespace Manager
}
\examples{
\dontrun{
   GSNamespaceManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{namespace}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSManager]{geosapi::GSManager}} -> \code{GSNamespaceManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSNamespaceManager-getNamespaces}{\code{GSNamespaceManager$getNamespaces()}}
\item \href{#method-GSNamespaceManager-getNamespaceNames}{\code{GSNamespaceManager$getNamespaceNames()}}
\item \href{#method-GSNamespaceManager-getNamespace}{\code{GSNamespaceManager$getNamespace()}}
\item \href{#method-GSNamespaceManager-createNamespace}{\code{GSNamespaceManager$createNamespace()}}
\item \href{#method-GSNamespaceManager-updateNamespace}{\code{GSNamespaceManager$updateNamespace()}}
\item \href{#method-GSNamespaceManager-deleteNamespace}{\code{GSNamespaceManager$deleteNamespace()}}
\item \href{#method-GSNamespaceManager-clone}{\code{GSNamespaceManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="ERROR"><a href='../../geosapi/html/GSManager.html#method-GSManager-ERROR'><code>geosapi::GSManager$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="INFO"><a href='../../geosapi/html/GSManager.html#method-GSManager-INFO'><code>geosapi::GSManager$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="WARN"><a href='../../geosapi/html/GSManager.html#method-GSManager-WARN'><code>geosapi::GSManager$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="connect"><a href='../../geosapi/html/GSManager.html#method-GSManager-connect'><code>geosapi::GSManager$connect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getClassName"><a href='../../geosapi/html/GSManager.html#method-GSManager-getClassName'><code>geosapi::GSManager$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getCoverageStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getCoverageStoreManager'><code>geosapi::GSManager$getCoverageStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getDataStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getDataStoreManager'><code>geosapi::GSManager$getDataStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getNamespaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getNamespaceManager'><code>geosapi::GSManager$getNamespaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getServiceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getServiceManager'><code>geosapi::GSManager$getServiceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getStyleManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getStyleManager'><code>geosapi::GSManager$getStyleManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getSystemStatus"><a href='../../geosapi/html/GSManager.html#method-GSManager-getSystemStatus'><code>geosapi::GSManager$getSystemStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getUrl"><a href='../../geosapi/html/GSManager.html#method-GSManager-getUrl'><code>geosapi::GSManager$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getWorkspaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getWorkspaceManager'><code>geosapi::GSManager$getWorkspaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="initialize"><a href='../../geosapi/html/GSManager.html#method-GSManager-initialize'><code>geosapi::GSManager$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="logger"><a href='../../geosapi/html/GSManager.html#method-GSManager-logger'><code>geosapi::GSManager$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="monitor"><a href='../../geosapi/html/GSManager.html#method-GSManager-monitor'><code>geosapi::GSManager$monitor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="reload"><a href='../../geosapi/html/GSManager.html#method-GSManager-reload'><code>geosapi::GSManager$reload()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSNamespaceManager-getNamespaces"></a>}}
\if{latex}{\out{\hypertarget{method-GSNamespaceManager-getNamespaces}{}}}
\subsection{Method \code{getNamespaces()}}{
Get the list of available namespace. Re
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSNamespaceManager$getNamespaces()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{list} containing items of class \code{\link{GSNamespace}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSNamespaceManager-getNamespaceNames"></a>}}
\if{latex}{\out{\hypertarget{method-GSNamespaceManager-getNamespaceNames}{}}}
\subsection{Method \code{getNamespaceNames()}}{
Get the list of available namespace names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSNamespaceManager$getNamespaceNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a vector of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSNamespaceManager-getNamespace"></a>}}
\if{latex}{\out{\hypertarget{method-GSNamespaceManager-getNamespace}{}}}
\subsection{Method \code{getNamespace()}}{
Get a \code{\link{GSNamespace}} object given a namespace name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSNamespaceManager$getNamespace(ns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ns}}{namespace}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSNamespace}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSNamespaceManager-createNamespace"></a>}}
\if{latex}{\out{\hypertarget{method-GSNamespaceManager-createNamespace}{}}}
\subsection{Method \code{createNamespace()}}{
Creates a GeoServer namespace given a prefix, and an optional URI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSNamespaceManager$createNamespace(prefix, uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{prefix}

\item{\code{uri}}{uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the namespace has been successfully created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSNamespaceManager-updateNamespace"></a>}}
\if{latex}{\out{\hypertarget{method-GSNamespaceManager-updateNamespace}{}}}
\subsection{Method \code{updateNamespace()}}{
Updates a GeoServer namespace given a prefix, and an optional URI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSNamespaceManager$updateNamespace(prefix, uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{prefix}

\item{\code{uri}}{uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the namespace has been successfully updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSNamespaceManager-deleteNamespace"></a>}}
\if{latex}{\out{\hypertarget{method-GSNamespaceManager-deleteNamespace}{}}}
\subsection{Method \code{deleteNamespace()}}{
Deletes a GeoServer namespace given a name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSNamespaceManager$deleteNamespace(name, recurse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}

\item{\code{recurse}}{recurse}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the namespace has been successfully deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSNamespaceManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSNamespaceManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSNamespaceManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
