% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-analysis.R
\name{prep_sar_data2}
\alias{prep_sar_data2}
\title{Prepare data for SAR model: raster analysis}
\source{
Griffith, Daniel A. (2000). Eigenfunction properties and approximations of selected incidence matrices employed in spatial analyses. \emph{Linear Algebra and its Applications} 321 (1-3): 95-112. \doi{10.1016/S0024-3795(00)00031-8}.
}
\usage{
prep_sar_data2(row, col, quiet = FALSE)
}
\arguments{
\item{row}{Number of rows in the raster}

\item{col}{Number of columns in the raster}

\item{quiet}{Controls printing behavior. By default, \code{quiet = FALSE} and the range of permissible values for the spatial dependence parameter is printed to the console.}
}
\value{
A list containing all of the data elements required by the SAR model in \code{\link[geostan]{stan_sar}}.
}
\description{
Prepares a list of data required for using the SAR model; this is for working with (large) raster data files. For non-raster analysis, see \link[geostan]{prep_sar_data}.
}
\details{
Prepare data for the SAR model when your raw dataset consists of observations on a regular tessellation, such as a raster layer or remotely sensed imagery. The rook criteria is used to determine adjacency. This function uses Equation 5 from Griffith (2000) to calculate the eigenvalues for a row-standardized spatial weights matrix of a P-by-Q dimension regular tessellation.

This function can accommodate very large numbers of observations for use with \code{\link[geostan]{stan_sar}}; for large N data, it is also recommended to use \code{slim = TRUE} or the \code{drop} argument. For details, see: \code{vignette("raster-regression", package = "geostan")}.
}
\examples{

row = 100
col = 120
sar_dl <- prep_sar_data2(row = row, col = col)

}
\seealso{
\code{\link[geostan]{prep_car_data2}}, \code{\link[geostan]{prep_sar_data}}, \code{\link[geostan]{stan_sar}}.
}
