% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna_tools.R
\name{debug_join_vector_num}
\alias{debug_join_vector_num}
\title{Print a numeric vector to console (\code{ggDNAvis} debug helper)}
\usage{
debug_join_vector_num(vector)
}
\arguments{
\item{vector}{\verb{numeric vector}. Usually generated by some other function. This function allows copy-pasting the output to directly create a vector with this value.}
}
\value{
None (invisible \code{NULL}) - uses \code{\link[=cat]{cat()}} to output directly to console.
}
\description{
Takes a numeric vector, and prints it to the console separated by \code{", "}.\cr\cr
This allows the output to be copy-pasted into a vector within an R script.
Used for taking vector outputs and then writing them as literals within a script. \cr\cr
E.g. when given input \code{1:5}, prints \verb{1, 2, 3, 4, 5}, which can be directly copy-pasted
within \code{c()} to input that vector. Printing normally via \code{print(1:5)} instead prints
\verb{[1] 1 2 3 4 5}, which is not valid vector input so can't be copy-pasted directly.\cr\cr
See \code{\link[=debug_join_vector_str]{debug_join_vector_str()}} for the equivalent for character/string vectors.
}
\examples{
debug_join_vector_num(1:5)

}
