% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_centroids.R
\name{geom_centroids}
\alias{geom_centroids}
\title{Geographic centroid of locations}
\usage{
geom_centroids(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "automap_coords",
  position = "circle_repel_sf",
  ...,
  fun.geometry = NULL,
  feature_type = NA,
  inset = NA,
  map_base = "clip",
  map_inset = "auto",
  na.rm = TRUE,
  show.legend = "point",
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, fun.geometry, ...}{See \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}}.}

\item{feature_type}{Type of map feature. See \code{\link[cartographer:feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}

\item{inset}{Inset configuration; see \code{\link[ggmapinset:configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[ggmapinset:coord_sf_inset]{coord_sf_inset()}}).}

\item{map_base}{Controls the layer with the base map. Possible values are
\code{"normal"} to create a layer as though the inset were not specified,
\code{"clip"} to create a layer with the inset viewport cut out, and
\code{"none"} to prevent the insertion of a layer for the base map.}

\item{map_inset}{Controls the layer with the inset map. Possible values are
\code{"auto"} to choose the behaviour based on whether \code{inset} is specified,
\code{"normal"} to create a layer with the viewport cut out and transformed, and
\code{"none"} to prevent the insertion of a layer for the viewport map.}
}
\value{
A ggplot layer.
}
\description{
Assigns each point a longitude and latitude corresponding to the geographic
centre of its administrative area. This means that all points in the same
area will overlap. The default \code{position} uses \code{\link[=position_circle_repel]{position_circle_repel()}}
to repel the points outwards with an amount controllable with its
\code{scale} parameter.
}
\section{Aesthetics}{

The \code{location} aesthetic is required.
\code{geom_centroids()} understands the same aesthetics as \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.
}

\examples{
library(ggplot2)

cartographer::nc_type_example_2 |>
  head(n = 100) |>
  ggplot(aes(location = county)) +
  geom_boundaries(feature_type = "sf.nc") +
  geom_centroids(aes(colour = type), position = position_circle_repel_sf(scale = 6), size = 0.5) +
  coord_automap(feature_type = "sf.nc")
}
