% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_hourglass.R
\docType{data}
\name{GeomHourglass}
\alias{GeomHourglass}
\alias{geom_hourglass}
\title{Add an 'hourglass' layer to a ggplot}
\format{
An object of class \code{GeomHourglass} (inherits from \code{GeomPoint}, \code{Geom}, \code{ggproto}, \code{gg}) of length 3.
}
\usage{
GeomHourglass

geom_hourglass(
  mapping = NULL,
  data = NULL,
  stat = "hourglass",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  hour_center = 0,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}. If
specified and \code{inherit.aes = TRUE} (the default), it is combined with the
default mapping at the top level of the plot. You must supply mapping if
there is no plot mapping. The \code{hourglass} \code{stat} and \code{geom} requires either
the \code{x} axis or the \code{y} axis to be mapped. The mapped aesthetic will show
the date of the variable, whereas the opposite axis will show the time of day.}

\item{data}{The data to be displayed in this layer. If \code{NULL}, the default,
the data is inherited from the plot data as specified in the call to
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}. Otherwise, a \code{data.frame}, or other object, will override
the plot data. All objects will be fortified to produce a data frame.
See \code{\link[ggplot2:fortify]{ggplot2::fortify()}} for which variables will be created. The data should
contain a column with datetime values (e.g., \code{?POSIXct})}

\item{stat}{Can be used to overwrite the default connection between \code{geom_hourglass}
and \code{\link[=stat_hourglass]{stat_hourglass()}}.}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning.
If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{hour_center}{The hour at which the time of day is centred. Default is 0,
meaning midnight. -12 centres around noon of the preceding day, +12 centres
around noon of the next day.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Arguments passed to geometry.}
}
\value{
Returns a \code{\link[ggplot2:layer]{ggplot2::layer()}} which can be added to a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
\code{geom_hourglass()} takes a continuous datetime object, splits in in discrete dates and
time of day with \code{stat_hourglass()}. This geometry is a wrapper
to add it as a layer to a ggplot. \code{GeomHourglass} is a ggproto object inheriting from
\code{?ggplot2::GeomPoint}. It should not be used directly. Instead call \code{\link[=geom_hourglass]{geom_hourglass()}}.
}
\examples{
library(ggplot2)
data(bats)

monitoring <- attr(bats, "monitoring")

ggplot(subset(bats, format(RECDATETIME, "\%Y") == "2019"),
       aes(x = RECDATETIME, col = SPECDESCSCI)) +
  geom_hourglass()

ggplot(dplyr::mutate(bats, YEAR = format(RECDATETIME, "\%Y")),
       aes(x = RECDATETIME, col = SPECDESCSCI)) +
  geom_hourglass() +
  facet_wrap(~YEAR, scales = "free_x")

}
\author{
Pepijn de Vries
}
\keyword{datasets}
