% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{radon}
\alias{radon}
\title{Simulations of the parameters of a hierarchical model}
\format{
A list containing several elements (data and outputs of the analysis):
\describe{
  \item{counties}{A data frame with the country label, ids and radon level.}
  \item{id.county}{A vector identifying counties in the data.}
  \item{y}{The outcome variable.}
  \item{s.radon}{A coda object with simulated values from the posterior distribution of all parameters, with few iterations for each one.}
  \item{s.radon.yhat}{A coda object containing simulated values from the posterior predictive distribution.}
  \item{s.radon.short}{A coda object with simulated values from the posterior distribution of few parameters, with reasonable chain length.}
}
}
\source{
Gelman & Hill
}
\usage{
data(radon)
}
\description{
Using the radon example in Gelman & Hill (2007), the list contains several elements to show the possibilities of ggmcmc for applied Bayesian Hierarchical/multilevel analysis.
}
\examples{
data(radon)
names(radon)
# Generate a data frame suitable for matching with the generated samples
# through the "par_labels" function:
L.radon <- plab("alpha", match = list(County = radon$counties$County))

}
\keyword{datasets}
