% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_add_inplace}
\alias{ggml_add_inplace}
\title{Element-wise Addition In-place (Graph)}
\usage{
ggml_add_inplace(ctx, a, b)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{First tensor (will be modified in-place)}

\item{b}{Second tensor (same shape as a)}
}
\value{
View of tensor a with the addition result
}
\description{
Creates a graph node for in-place element-wise addition.
Result is stored in tensor a, saving memory allocation.
Returns a view of the modified tensor.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
ggml_set_f32(b, c(5, 4, 3, 2, 1))
result <- ggml_add_inplace(ctx, a, b)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_get_f32(result)
ggml_free(ctx)
}
}
