% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggml.R
\name{ggml_reset}
\alias{ggml_reset}
\title{Reset GGML Context}
\usage{
ggml_reset(ctx)
}
\arguments{
\item{ctx}{GGML context pointer}
}
\value{
NULL (invisible)
}
\description{
Clears all tensor allocations in the context memory pool.
The context can be reused without recreating it.
This is more efficient than free + init for temporary operations.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 100)
ggml_reset(ctx)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 200)
ggml_free(ctx)
}
}
